<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<?php
	/**
	 * dor_mikado_action_header_meta hook
	 *
	 * @see dor_mikado_header_meta() - hooked with 10
	 * @see dor_mikado_user_scalable_meta - hooked with 10
	 * @see dor_core_set_open_graph_meta - hooked with 10
	 */
	do_action( 'dor_mikado_action_header_meta' );
	
	wp_head(); ?>
</head>
<body <?php body_class(); ?> itemscope itemtype="https://schema.org/WebPage">
    <?php
        // Hook to include default WordPress hook after body tag open
        if ( function_exists( 'wp_body_open' ) ) {
            wp_body_open();
        }
    ?>
    <div class="mkdf-wrapper">
        <div class="mkdf-wrapper-inner">
            <?php
            /**
             * dor_mikado_action_after_wrapper_inner hook
             *
             * @see dor_mikado_get_header() - hooked with 10
             * @see dor_mikado_get_mobile_header() - hooked with 20
             * @see dor_mikado_back_to_top_button() - hooked with 30
             * @see dor_mikado_get_header_minimal_full_screen_menu() - hooked with 40
             * @see dor_mikado_get_header_bottom_navigation() - hooked with 40
             */
            do_action( 'dor_mikado_action_after_wrapper_inner' ); ?>
	        
            <div class="mkdf-content" <?php dor_mikado_content_elem_style_attr(); ?>>
                <div class="mkdf-content-inner">