<?php

if ( class_exists( 'DorCoreClassWidget' ) ) {
	class DorMikadoClassWoocommerceDropdownCart extends DorCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'mkdf_woocommerce_dropdown_cart',
				esc_html__('Dor Woocommerce Dropdown Cart', 'dor'),
				array('description' => esc_html__('Display a shop cart icon with a dropdown that shows products that are in the cart', 'dor'),)
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'        => 'textfield',
					'name'        => 'woocommerce_dropdown_cart_margin',
					'title'       => esc_html__('Icon Margin', 'dor'),
					'description' => esc_html__('Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'dor')
				),
				array(
					'type'        => 'textfield',
					'name'        => 'woocommerce_dropdown_cart_padding',
					'title'       => esc_html__('Icon Padding', 'dor'),
					'description' => esc_html__('Insert padding in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'dor')
				)
			);
		}
		
		public function widget( $args, $instance ) {
			// Prevent widgets from loading on WooCommerce cart page
			if ( function_exists( 'is_cart' ) && is_cart() ) {
				return;
			}
			
			$icon_styles = array();
			
			if ( $instance['woocommerce_dropdown_cart_margin'] !== '' ) {
				$icon_styles[] = 'margin: ' . $instance['woocommerce_dropdown_cart_margin'];
			}
			
			?>
			<div class="mkdf-shopping-cart-holder" <?php dor_mikado_inline_style( $icon_styles ) ?>>
				<div class="mkdf-shopping-cart-inner">
					<?php dor_mikado_get_module_template_part( 'widgets/woocommerce-dropdown-cart/templates/content', 'woocommerce' ); ?>
				</div>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'dor_mikado_woocommerce_header_add_to_cart_fragment' ) ) {
	function dor_mikado_woocommerce_header_add_to_cart_fragment( $fragments ) {
		ob_start();
		?>
		<div class="mkdf-shopping-cart-inner">
			<?php dor_mikado_get_module_template_part( 'widgets/woocommerce-dropdown-cart/templates/content', 'woocommerce' ); ?>
		</div>
		
		<?php
		$fragments['div.mkdf-shopping-cart-inner'] = ob_get_clean();
		
		return $fragments;
	}
	
	add_filter( 'woocommerce_add_to_cart_fragments', 'dor_mikado_woocommerce_header_add_to_cart_fragment' );
}