<?php

if ( ! function_exists( 'dor_mikado_map_woocommerce_meta' ) ) {
	function dor_mikado_map_woocommerce_meta() {
		
		$woocommerce_meta_box = dor_mikado_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'dor' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'dor' ),
				'description' => esc_html__( 'Choose image layout when it appears in Mikado Product List - Masonry layout shortcode', 'dor' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'dor' ),
					'small'              => esc_html__( 'Small', 'dor' ),
					'large-width'        => esc_html__( 'Large Width', 'dor' ),
					'large-height'       => esc_html__( 'Large Height', 'dor' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'dor' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'dor' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'dor' ),
				'options'       => dor_mikado_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'dor' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'dor' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'dor_mikado_action_meta_boxes_map', 'dor_mikado_map_woocommerce_meta', 99 );
}