<?php

if ( class_exists( 'DorCoreClassWidget' ) ) {
	class DorMikadoClassSeparatorWidget extends DorCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'mkdf_separator_widget',
				esc_html__( 'Dor Separator Widget', 'dor' ),
				array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'dor' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'dor' ),
					'options' => array(
						'normal'     => esc_html__( 'Normal', 'dor' ),
						'full-width' => esc_html__( 'Full Width', 'dor' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'position',
					'title'   => esc_html__( 'Position', 'dor' ),
					'options' => array(
						'center' => esc_html__( 'Center', 'dor' ),
						'left'   => esc_html__( 'Left', 'dor' ),
						'right'  => esc_html__( 'Right', 'dor' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'border_style',
					'title'   => esc_html__( 'Style', 'dor' ),
					'options' => array(
						'solid'  => esc_html__( 'Solid', 'dor' ),
						'dashed' => esc_html__( 'Dashed', 'dor' ),
						'dotted' => esc_html__( 'Dotted', 'dor' )
					)
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'dor' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'width',
					'title' => esc_html__( 'Width (px or %)', 'dor' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'thickness',
					'title' => esc_html__( 'Thickness (px)', 'dor' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'top_margin',
					'title' => esc_html__( 'Top Margin (px or %)', 'dor' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'bottom_margin',
					'title' => esc_html__( 'Bottom Margin (px or %)', 'dor' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			//prepare variables
			$params = '';
			
			//is instance empty?
			if ( is_array( $instance ) && count( $instance ) ) {
				//generate shortcode params
				foreach ( $instance as $key => $value ) {
					$params .= " $key='$value' ";
				}
			}
			
			echo '<div class="widget mkdf-separator-widget">';
			echo do_shortcode( "[mkdf_separator $params]" ); // XSS OK
			echo '</div>';
		}
	}
}