<?php

if ( class_exists( 'DorCoreClassWidget' ) ) {
	class DorMikadoClassButtonWidget extends DorCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'mkdf_button_widget',
				esc_html__( 'Dor Button Widget', 'dor' ),
				array( 'description' => esc_html__( 'Add button element to widget areas', 'dor' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'dor' ),
					'options' => array(
						'solid'   => esc_html__( 'Solid', 'dor' ),
						'outline' => esc_html__( 'Outline', 'dor' ),
						'simple'  => esc_html__( 'Simple', 'dor' )
					)
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'size',
					'title'       => esc_html__( 'Size', 'dor' ),
					'options'     => array(
						'small'  => esc_html__( 'Small', 'dor' ),
						'medium' => esc_html__( 'Medium', 'dor' ),
						'large'  => esc_html__( 'Large', 'dor' ),
						'huge'   => esc_html__( 'Huge', 'dor' )
					),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'dor' )
				),
				array(
					'type'    => 'textfield',
					'name'    => 'text',
					'title'   => esc_html__( 'Text', 'dor' ),
					'default' => esc_html__( 'Button Text', 'dor' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'link',
					'title' => esc_html__( 'Link', 'dor' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'target',
					'title'   => esc_html__( 'Link Target', 'dor' ),
					'options' => dor_mikado_get_link_target_array()
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'dor' )
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'hover_color',
					'title' => esc_html__( 'Hover Color', 'dor' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'background_color',
					'title'       => esc_html__( 'Background Color', 'dor' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'dor' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_background_color',
					'title'       => esc_html__( 'Hover Background Color', 'dor' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'dor' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'border_color',
					'title'       => esc_html__( 'Border Color', 'dor' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'dor' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_border_color',
					'title'       => esc_html__( 'Hover Border Color', 'dor' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'dor' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'margin',
					'title'       => esc_html__( 'Margin', 'dor' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'dor' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$params = '';
			
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			// Filter out all empty params
			$instance = array_filter( $instance, function ( $array_value ) {
				return trim( $array_value ) != '';
			} );
			
			// Default values
			if ( ! isset( $instance['text'] ) ) {
				$instance['text'] = 'Button Text';
			}
			
			// Generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
			
			echo '<div class="widget mkdf-button-widget">';
			echo do_shortcode( "[mkdf_button $params]" ); // XSS OK
			echo '</div>';
		}
	}
}