<?php

if ( ! function_exists( 'dor_mikado_logo_options_map' ) ) {
	function dor_mikado_logo_options_map() {
		
		dor_mikado_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'dor' ),
				'icon'  => 'fa fa-coffee'
			)
		);

		$panel_logo = dor_mikado_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'dor' )
			)
		);

		dor_mikado_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'dor' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'dor' )
			)
		);

		$hide_logo_container = dor_mikado_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'dependency' => array(
					'hide' => array(
						'hide_logo'  => 'yes'
					)
				)
			)
		);

        dor_mikado_add_admin_field(
            array(
                'parent'        => $hide_logo_container,
                'type'          => 'select',
                'name'          => 'logo_source',
                'default_value' => 'image',
                'label'         => esc_html__( 'Select Logo Source', 'dor' ),
                'description'   => esc_html__( 'Choose whether you would like to use logo as image or text', 'dor' ),
                'options'       => array(
                    'image' => esc_html__( 'Image', 'dor' ),
                    'text' => esc_html__( 'Text', 'dor' )
                )
            )
        );

        $image_logo_container = dor_mikado_add_admin_container(
            array(
                'parent'          => $hide_logo_container,
                'name'            => 'image_logo_container',
                'dependency' => array(
                    'hide' => array(
                        'logo_source'  => 'text'
                    )
                )
            )
        );

		dor_mikado_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => MIKADO_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'dor' ),
				'parent'        => $image_logo_container
			)
		);

		dor_mikado_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => MIKADO_ASSETS_ROOT . "/img/logo_black.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'dor' ),
				'parent'        => $image_logo_container
			)
		);

		dor_mikado_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => MIKADO_ASSETS_ROOT . "/img/logo_white.png",
				'label'         => esc_html__( 'Logo Image - Light', 'dor' ),
				'parent'        => $image_logo_container
			)
		);

		dor_mikado_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => MIKADO_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'dor' ),
				'parent'        => $image_logo_container
			)
		);

		dor_mikado_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => MIKADO_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'dor' ),
				'parent'        => $image_logo_container
			)
		);

        dor_mikado_add_admin_field(
            array(
                'parent'      => $hide_logo_container,
                'type'        => 'text',
                'name'        => 'logo_text',
                'label'       => esc_html__( 'Logo Text', 'dor' ),
                'description' => esc_html__( 'Enter your logo text here', 'dor' ),
                'dependency' => array(
                    'hide' => array(
                        'logo_source'  => 'image'
                    )
                )
            )
        );

        dor_mikado_add_admin_field(
			array(
				'parent'      => $hide_logo_container,
				'type'        => 'text',
				'name'        => 'logo_text_font_size',
				'label'       => esc_html__( 'Logo Text Font Size (px)', 'dor' ),
				'description' => esc_html__( 'Enter font size for your logo text', 'dor' ),
				'args'        => array(
					'col_width' => 2,
					'suffix'    => esc_html__( 'px', 'dor' )
				),
				'dependency' => array(
					'hide' => array(
						'logo_source'  => 'image'
					)
				)
			)
		);

        dor_mikado_add_admin_field(
            array(
                'parent'      => $hide_logo_container,
                'type'        => 'color',
                'name'        => 'logo_text_color',
                'label'       => esc_html__( 'Logo Text Color', 'dor' ),
                'description' => esc_html__( 'Choose color for your logo text', 'dor' ),
                'dependency' => array(
                    'hide' => array(
                        'logo_source'  => 'image'
                    )
                )
            )
        );

		dor_mikado_add_admin_field(
			array(
				'parent'      => $hide_logo_container,
				'type'        => 'text',
				'name'        => 'mobile_logo_text',
				'label'       => esc_html__( 'Mobile Logo Text', 'dor' ),
				'description' => esc_html__( 'Enter your logo text here for mobile device', 'dor' ),
				'dependency' => array(
					'hide' => array(
						'logo_source'  => 'image'
					)
				)
			)
		);
	}
	
	add_action( 'dor_mikado_action_options_map', 'dor_mikado_logo_options_map', dor_mikado_set_options_map_position( 'logo' ) );
}