<?php
$image_size      = isset( $image_size ) ? $image_size : 'full';
$bg_image_styles = array();

if (has_post_thumbnail()) {
	$bg_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), $image_size );

	$bg_image_styles[] = 'background-image: url(' . $bg_image_url[0] . ')';
	$bg_image_styles[] = 'background-repeat: no-repeat';
	$bg_image_styles[] = 'background-size: cover';
	$bg_image_styles[] = 'background-position-x: right';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="mkdf-post-content">
		<div class="mkdf-post-text" <?php echo dor_mikado_get_inline_style($bg_image_styles); ?>>
			<div class="mkdf-post-text-inner">
				<div class="mkdf-post-text-main">
					<div class="mkdf-post-mark">
						<span class="mkdf-quote-mark"></span>
					</div>
					<?php dor_mikado_get_module_template_part( 'templates/parts/post-type/quote', 'blog', '', $part_params ); ?>
				</div>
				<div class="mkdf-post-info-bottom clearfix">
					<?php dor_mikado_get_module_template_part( 'templates/parts/post-info/author', 'blog', '', $part_params ); ?>
				</div>
			</div>
		</div>
	</div>
	<div class="mkdf-post-additional-content">
		<?php the_content(); ?>
	</div>
	<div class="mkdf-post-info-bottom mkdf-post-all-info clearfix">
		<div class="mkdf-post-info-bottom-left">
			<?php dor_mikado_get_module_template_part( 'templates/parts/post-info/share', 'blog', '', $part_params ); ?>
		</div>
		<div class="mkdf-post-info-bottom-right">
			<?php dor_mikado_get_module_template_part( 'templates/parts/post-info/tags', 'blog', '', $part_params ); ?>
		</div>
	</div>
</article>