<?php

if ( ! function_exists( 'dor_mikado_include_blog_shortcodes' ) ) {
	function dor_mikado_include_blog_shortcodes() {
		foreach ( glob( MIKADO_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/*/load.php' ) as $shortcode_load ) {
			include_once $shortcode_load;
		}
	}
	
	if ( dor_mikado_is_plugin_installed( 'core' ) ) {
		add_action( 'dor_core_action_include_shortcodes_file', 'dor_mikado_include_blog_shortcodes' );
	}
}
// Load blog elementor widgets
if ( ! function_exists( 'dor_mikado_include_blog_elementor_widgets_files' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function dor_mikado_include_blog_elementor_widgets_files() {
		if ( dor_mikado_is_plugin_installed('core') && function_exists('dor_core_is_theme_registered') && dor_core_is_theme_registered() ) {
			foreach ( glob( MIKADO_FRAMEWORK_MODULES_ROOT_DIR . '/blog/shortcodes/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}
	
	if ( defined('ELEMENTOR_VERSION') ) {
		if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
			add_action( 'elementor/widgets/register', 'dor_mikado_include_blog_elementor_widgets_files' );
		} else {
			add_action( 'elementor/widgets/widgets_registered', 'dor_mikado_include_blog_elementor_widgets_files' );
		}
	}
}