<?php
class DorMikadoElementorBlogSlider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'mkdf_blog_slider'; 
	}

	public function get_title() {
		return esc_html__( 'Blog Slider', 'dor' );
	}

	public function get_icon() {
		return 'dor-elementor-custom-icon dor-elementor-blog-slider';
	}

	public function get_categories() {
		return [ 'mikado' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'dor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_type',
			[
				'label'     => esc_html__( 'Type', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'slider' => esc_html__( 'Slider', 'dor'), 
					'carousel' => esc_html__( 'Carousel', 'dor'), 
					'carousel-centered' => esc_html__( 'Carousel Centered', 'dor')
				),
				'default' => 'slider'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Posts', 'dor' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'dor'), 
					'ID' => esc_html__( 'ID', 'dor'), 
					'menu_order' => esc_html__( 'Menu Order', 'dor'), 
					'name' => esc_html__( 'Post Name', 'dor'), 
					'rand' => esc_html__( 'Random', 'dor'), 
					'title' => esc_html__( 'Title', 'dor')
				),
				'default' => 'title'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'dor'), 
					'DESC' => esc_html__( 'DESC', 'dor')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category', 'dor' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'dor' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'full' => esc_html__( 'Original', 'dor'), 
					'dor_mikado_image_square' => esc_html__( 'Square', 'dor'), 
					'dor_mikado_image_landscape' => esc_html__( 'Landscape', 'dor'), 
					'dor_mikado_image_portrait' => esc_html__( 'Portrait', 'dor'), 
					'thumbnail' => esc_html__( 'Thumbnail', 'dor'), 
					'medium' => esc_html__( 'Medium', 'dor'), 
					'large' => esc_html__( 'Large', 'dor'), 
					'custom' => esc_html__( 'Custom', 'dor')
				),
				'default' => 'full'
			]
		);

		$this->add_control(
			'custom_image_width',
			[
				'label'     => esc_html__( 'Custom Image Width', 'dor' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image width in px', 'dor' ),
				'condition' => [
					'image_size' => array( 'custom' )
				]
			]
		);

		$this->add_control(
			'custom_image_height',
			[
				'label'     => esc_html__( 'Custom Image Height', 'dor' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image height in px', 'dor' ),
				'condition' => [
					'image_size' => array( 'custom' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'post_info',
			[
				'label' => esc_html__( 'Post Info', 'dor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'h1' => esc_html__( 'h1', 'dor'), 
					'h2' => esc_html__( 'h2', 'dor'), 
					'h3' => esc_html__( 'h3', 'dor'), 
					'h4' => esc_html__( 'h4', 'dor'), 
					'h5' => esc_html__( 'h5', 'dor'), 
					'h6' => esc_html__( 'h6', 'dor')
				),
				'default' => 'h2'
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'dor'), 
					'none' => esc_html__( 'None', 'dor'), 
					'capitalize' => esc_html__( 'Capitalize', 'dor'), 
					'uppercase' => esc_html__( 'Uppercase', 'dor'), 
					'lowercase' => esc_html__( 'Lowercase', 'dor'), 
					'initial' => esc_html__( 'Initial', 'dor'), 
					'inherit' => esc_html__( 'Inherit', 'dor')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'post_info_author',
			[
				'label'     => esc_html__( 'Enable Post Info Author', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'dor'), 
					'no' => esc_html__( 'No', 'dor')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_date',
			[
				'label'     => esc_html__( 'Enable Post Info Date', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'dor'), 
					'no' => esc_html__( 'No', 'dor')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_category',
			[
				'label'     => esc_html__( 'Enable Post Info Category', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'dor'), 
					'no' => esc_html__( 'No', 'dor')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_comments',
			[
				'label'     => esc_html__( 'Enable Post Info Comments', 'dor' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'dor'), 
					'yes' => esc_html__( 'Yes', 'dor')
				),
				'default' => 'no'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$queryArray             = $this->generateBlogQueryArray( $params );
		$query_result           = new \WP_Query( $queryArray );
		$params['query_result'] = $query_result;
		
		$params['slider_type']    = ! empty( $params['slider_type'] ) ? $params['slider_type'] : 'slider';
		$params['slider_classes'] = $this->getSliderClasses( $params );
		$params['slider_data']    = $this->getSliderData( $params );
		
		ob_start();
		
		dor_mikado_get_module_template_part( 'shortcodes/blog-slider/holder', 'blog', '', $params );
		
		$html = ob_get_contents();
		
		ob_end_clean();
		
		echo dor_mikado_get_module_part($html);
	}

	public function generateBlogQueryArray( $params ) {
		$queryArray = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'orderby'        => $params['orderby'],
			'order'          => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'post__not_in'   => get_option( 'sticky_posts' )
		);
		
		if ( ! empty( $params['category'] ) ) {
			$queryArray['category_name'] = $params['category'];
		}
		
		return $queryArray;
	}

	public function getSliderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = 'mkdf-bs-' . $params['slider_type'];
		
		return implode( ' ', $holderClasses );
	}

	private function getSliderData( $params ) {
		$type        = $params['slider_type'];
		$slider_data = array();
		
		if($type == 'carousel') {
			$slider_data['data-number-of-items']   = '2';
			$slider_data['data-slider-margin']     = '80';
			$slider_data['data-slider-padding']    = 'yes';
			$slider_data['data-enable-navigation'] = 'no';
		} else if ($type == 'carousel-centered') {
			$slider_data['data-number-of-items']   = '2';
			$slider_data['data-slider-margin']     = '30';
			$slider_data['data-enable-center']     = 'yes';
			$slider_data['data-enable-navigation'] = 'yes';
			$slider_data['data-enable-pagination'] = 'yes';
		} else {
			$slider_data['data-number-of-items']   = '1';
			$slider_data['data-enable-pagination'] = 'yes';
		}
		
		return $slider_data;
	}

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new DorMikadoElementorBlogSlider() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new DorMikadoElementorBlogSlider() );
}