(function ($) {
	"use strict";

	var blog = {};
	mkdf.modules.blog = blog;

	blog.mkdfOnDocumentReady = mkdfOnDocumentReady;
	blog.mkdfOnWindowLoad = mkdfOnWindowLoad;
	blog.mkdfOnWindowScroll = mkdfOnWindowScroll;

	$(document).ready(mkdfOnDocumentReady);
	$(window).on('load', mkdfOnWindowLoad);
	$(window).scroll(mkdfOnWindowScroll);

	/* 
		All functions to be called on $(document).ready() should be in this function
	*/
	function mkdfOnDocumentReady() {
		mkdfInitAudioPlayer();
	}

	/* 
		All functions to be called on $(window).load() should be in this function
	*/
	function mkdfOnWindowLoad() {
		mkdfInitBlogPagination().init();
	}

	/* 
		All functions to be called on $(window).scroll() should be in this function
	*/
	function mkdfOnWindowScroll() {
		mkdfInitBlogPagination().scroll();
	}

	/**
	* Init audio player for Blog list and single pages
	*/
	function mkdfInitAudioPlayer() {
		var players = $('audio.mkdf-blog-audio');

		if (players.length) {
			players.mediaelementplayer({
				audioWidth: '100%'
			});
		}
	}

	/**
	 * Initializes blog pagination functions
	 */
	function mkdfInitBlogPagination() {
		var holder = $('.mkdf-blog-holder');

		var initLoadMorePagination = function (thisHolder) {
			var loadMoreButton = thisHolder.find('.mkdf-blog-pag-load-more a');

			loadMoreButton.on('click', function (e) {
				e.preventDefault();
				e.stopPropagation();

				initMainPagFunctionality(thisHolder);
			});
		};

		var initInifiteScrollPagination = function (thisHolder) {
			var blogListHeight = thisHolder.outerHeight(),
				blogListTopOffest = thisHolder.offset().top,
				blogListPosition = blogListHeight + blogListTopOffest - mkdfGlobalVars.vars.mkdfAddForAdminBar;

			if (!thisHolder.hasClass('mkdf-blog-pagination-infinite-scroll-started') && mkdf.scroll + mkdf.windowHeight > blogListPosition) {
				initMainPagFunctionality(thisHolder);
			}
		};

		var initMainPagFunctionality = function (thisHolder) {
			var thisHolderInner = thisHolder.children('.mkdf-blog-holder-inner'),
				nextPage,
				maxNumPages;

			if (typeof thisHolder.data('max-num-pages') !== 'undefined' && thisHolder.data('max-num-pages') !== false) {
				maxNumPages = thisHolder.data('max-num-pages');
			}

			if (thisHolder.hasClass('mkdf-blog-pagination-infinite-scroll')) {
				thisHolder.addClass('mkdf-blog-pagination-infinite-scroll-started');
			}

			var loadMoreDatta = mkdf.modules.common.getLoadMoreData(thisHolder),
				loadingItem = thisHolder.find('.mkdf-blog-pag-loading');

			nextPage = loadMoreDatta.nextPage;

			var nonceHolder = thisHolder.find('input[name*="mkdf_blog_load_more_nonce_"]');

			loadMoreDatta.blog_load_more_id = nonceHolder.attr('name').substring(nonceHolder.attr('name').length - 4, nonceHolder.attr('name').length);
			loadMoreDatta.blog_load_more_nonce = nonceHolder.val();

			if (nextPage <= maxNumPages) {
				loadingItem.addClass('mkdf-showing');

				var ajaxData = mkdf.modules.common.setLoadMoreAjaxData(loadMoreDatta, 'dor_mikado_blog_load_more');

				$.ajax({
					type: 'POST',
					data: ajaxData,
					url: mkdfGlobalVars.vars.mkdfAjaxUrl,
					success: function (data) {
						nextPage++;

						thisHolder.data('next-page', nextPage);

						var response = $.parseJSON(data),
							responseHtml = response.html;

						thisHolder.waitForImages(function () {
							if (thisHolder.hasClass('mkdf-grid-masonry-list')) {
								mkdfInitAppendIsotopeNewContent(thisHolderInner, loadingItem, responseHtml);
								mkdf.modules.common.setFixedImageProportionSize(thisHolder, thisHolder.find('article'), thisHolderInner.find('.mkdf-masonry-grid-sizer').width());
							} else {
								mkdfInitAppendGalleryNewContent(thisHolderInner, loadingItem, responseHtml);
							}

							setTimeout(function () {
								mkdfInitAudioPlayer();
								mkdf.modules.common.mkdfOwlSlider();
								mkdf.modules.common.mkdfFluidVideo();
								mkdf.modules.common.mkdfInitSelfHostedVideoPlayer();
								mkdf.modules.common.mkdfSelfHostedVideoSize();

								if (typeof mkdf.modules.common.mkdfStickySidebarWidget === 'function') {
									mkdf.modules.common.mkdfStickySidebarWidget().reInit();
								}

								// Trigger event.
								$(document.body).trigger('blog_list_load_more_trigger');

							}, 400);
						});

						if (thisHolder.hasClass('mkdf-blog-pagination-infinite-scroll-started')) {
							thisHolder.removeClass('mkdf-blog-pagination-infinite-scroll-started');
						}
					}
				});
			}

			if (nextPage === maxNumPages) {
				thisHolder.find('.mkdf-blog-pag-load-more').hide();
			}
		};

		var mkdfInitAppendIsotopeNewContent = function (thisHolderInner, loadingItem, responseHtml) {
			thisHolderInner.append(responseHtml).isotope('reloadItems').isotope({ sortBy: 'original-order' });
			loadingItem.removeClass('mkdf-showing');

			setTimeout(function () {
				thisHolderInner.isotope('layout');
			}, 600);
		};

		var mkdfInitAppendGalleryNewContent = function (thisHolderInner, loadingItem, responseHtml) {
			loadingItem.removeClass('mkdf-showing');
			thisHolderInner.append(responseHtml);
		};

		return {
			init: function () {
				if (holder.length) {
					holder.each(function () {
						var thisHolder = $(this);

						if (thisHolder.hasClass('mkdf-blog-pagination-load-more')) {
							initLoadMorePagination(thisHolder);
						}

						if (thisHolder.hasClass('mkdf-blog-pagination-infinite-scroll')) {
							initInifiteScrollPagination(thisHolder);
						}
					});
				}
			},
			scroll: function () {
				if (holder.length) {
					holder.each(function () {
						var thisHolder = $(this);

						if (thisHolder.hasClass('mkdf-blog-pagination-infinite-scroll')) {
							initInifiteScrollPagination(thisHolder);
						}
					});
				}
			}
		};
	}

})(jQuery);