<?php

/*** Post Settings ***/

if ( ! function_exists( 'dor_mikado_map_post_meta' ) ) {
	function dor_mikado_map_post_meta() {
		
		$post_meta_box = dor_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'dor' ),
				'name'  => 'post-meta'
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'dor' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'dor' ),
				'parent'        => $post_meta_box,
				'options'       => dor_mikado_get_yes_no_select_array()
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'dor' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'dor' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => dor_mikado_get_custom_sidebars_options( true )
			)
		);
		
		$dor_custom_sidebars = dor_mikado_get_custom_sidebars();
		if ( is_array( $dor_custom_sidebars ) && count( $dor_custom_sidebars ) > 0 ) {
			dor_mikado_create_meta_box_field( array(
				'name'        => 'mkdf_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'dor' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'dor' ),
				'parent'      => $post_meta_box,
				'options'     => dor_mikado_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'dor' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'dor' ),
				'parent'      => $post_meta_box
			)
		);

		do_action('dor_mikado_action_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'dor_mikado_action_meta_boxes_map', 'dor_mikado_map_post_meta', 20 );
}
