<?php

if ( ! function_exists( 'dor_mikado_map_post_video_meta' ) ) {
	function dor_mikado_map_post_video_meta() {
		$video_post_format_meta_box = dor_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'dor' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'dor' ),
				'description'   => esc_html__( 'Choose video type', 'dor' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'dor' ),
					'self'            => esc_html__( 'Self Hosted', 'dor' )
				)
			)
		);
		
		$mkdf_video_embedded_container = dor_mikado_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'mkdf_video_embedded_container'
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'dor' ),
				'description' => esc_html__( 'Enter Video URL', 'dor' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'dor' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'dor' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'dor' ),
				'description' => esc_html__( 'Enter video image', 'dor' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'dor_mikado_action_meta_boxes_map', 'dor_mikado_map_post_video_meta', 22 );
}