<?php

if ( ! function_exists( 'dor_mikado_map_general_meta' ) ) {
	function dor_mikado_map_general_meta() {
		
		$general_meta_box = dor_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'dor_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'dor' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'dor' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'dor' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'dor' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'dor' ),
				'parent'        => $general_meta_box
			)
		);
		
		$mkdf_content_padding_group = dor_mikado_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Styles', 'dor' ),
				'description' => esc_html__( 'Define styles for Content area', 'dor' ),
				'parent'      => $general_meta_box
			)
		);
		
			$mkdf_content_padding_row = dor_mikado_add_admin_row(
				array(
					'name'   => 'mkdf_content_padding_row',
					'parent' => $mkdf_content_padding_group
				)
			);
			
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_page_background_color_meta',
						'type'        => 'colorsimple',
						'label'       => esc_html__( 'Page Background Color', 'dor' ),
						'parent'      => $mkdf_content_padding_row
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_page_background_image_meta',
						'type'          => 'imagesimple',
						'label'         => esc_html__( 'Page Background Image', 'dor' ),
						'parent'        => $mkdf_content_padding_row
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_page_background_repeat_meta',
						'type'          => 'selectsimple',
						'default_value' => '',
						'label'         => esc_html__( 'Page Background Image Repeat', 'dor' ),
						'options'       => dor_mikado_get_yes_no_select_array(),
						'parent'        => $mkdf_content_padding_row
					)
				);
		
			$mkdf_content_padding_row_1 = dor_mikado_add_admin_row(
				array(
					'name'   => 'mkdf_content_padding_row_1',
					'next'   => true,
					'parent' => $mkdf_content_padding_group
				)
			);
		
				dor_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (eg. 10px 5px 10px 5px)', 'dor' ),
						'parent' => $mkdf_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'    => 'mkdf_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (eg. 10px 5px 10px 5px)', 'dor' ),
						'parent'  => $mkdf_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'dor' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'dor' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'dor' ),
					'mkdf-grid-1300' => esc_html__( '1300px', 'dor' ),
					'mkdf-grid-1200' => esc_html__( '1200px', 'dor' ),
					'mkdf-grid-1100' => esc_html__( '1100px', 'dor' ),
					'mkdf-grid-1000' => esc_html__( '1000px', 'dor' ),
					'mkdf-grid-800'  => esc_html__( '800px', 'dor' )
				)
			)
		);

		dor_mikado_create_meta_box_field(
            array(
                'name'    => 'mkdf_content_grid_lines_meta',
                'type'    => 'select',
                'label'   => esc_html__( 'Enable grid lines in background', 'dor' ),
                'parent'  => $general_meta_box,
                'options' => dor_mikado_get_yes_no_select_array()
            )
        );

		$additional_grid_lines_container_meta = dor_mikado_add_admin_container(
			array(
				'parent'          => $general_meta_box,
				'name'            => 'additional_grid_lines_container_meta',
				'dependency' => array(
					'hide' => array(
						'mkdf_content_grid_lines_meta' => array( '', 'no' )
					)
				)
			)
		);

		dor_mikado_create_meta_box_field(
			array(
				'type'        => 'select',
				'name'        => 'mkdf_grid_lines_in_grid_meta',
				'label'       => esc_html__( 'Enable Grid Layout', 'dor' ),
				'description' => esc_html__( 'Enabling this option will place Content Background Lines in grid', 'dor' ),
				'parent'      => $additional_grid_lines_container_meta,
				'options'     => dor_mikado_get_yes_no_select_array()
			)
		);

		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_page_grid_space_meta',
				'type'        => 'select',
				'default_value' => '',
				'label'       => esc_html__( 'Grid Layout Space', 'dor' ),
				'description' => esc_html__( 'Choose a space between content layout and sidebar layout for your page', 'dor' ),
				'options'     => dor_mikado_get_space_between_items_array( true ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		dor_mikado_create_meta_box_field(
			array(
				'name'    => 'mkdf_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'dor' ),
				'parent'  => $general_meta_box,
				'options' => dor_mikado_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = dor_mikado_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'mkdf_boxed_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'dor' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'dor' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'dor' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'dor' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'dor' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'dor' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Attachment', 'dor' ),
						'description'   => esc_html__( 'Choose background image attachment', 'dor' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'dor' ),
							'fixed'  => esc_html__( 'Fixed', 'dor' ),
							'scroll' => esc_html__( 'Scroll', 'dor' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'dor' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'dor' ),
				'parent'        => $general_meta_box,
				'options'       => dor_mikado_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = dor_mikado_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'mkdf_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'mkdf_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'dor' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'dor' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'dor' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'dor' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'dor' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'dor' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				dor_mikado_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'mkdf_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'dor' ),
						'options'       => dor_mikado_get_yes_no_select_array(),
					)
				);
		
				dor_mikado_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'mkdf_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'dor' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'dor' ),
						'options'       => dor_mikado_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		dor_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'dor' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'dor' ),
				'parent'        => $general_meta_box,
				'options'       => dor_mikado_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = dor_mikado_add_admin_container(
				array(
					'parent'     => $general_meta_box,
					'name'       => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'mkdf_smooth_page_transitions_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				dor_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'dor' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'dor' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => dor_mikado_get_yes_no_select_array()
					)
				);
		
				$page_transition_preloader_container_meta = dor_mikado_add_admin_container(
					array(
						'parent'     => $page_transitions_container_meta,
						'name'       => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'mkdf_page_transition_preloader_meta' => array( '', 'no' )
							)
						)
					)
				);
				
					dor_mikado_create_meta_box_field(
						array(
							'name'   => 'mkdf_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'dor' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = dor_mikado_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'dor' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'dor' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = dor_mikado_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					dor_mikado_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'mkdf_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'dor' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'dor' ),
								'dor_spinner'           => esc_html__( 'Dor Spinner', 'dor' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'dor' ),
								'pulse'                 => esc_html__( 'Pulse', 'dor' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'dor' ),
								'cube'                  => esc_html__( 'Cube', 'dor' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'dor' ),
								'stripes'               => esc_html__( 'Stripes', 'dor' ),
								'wave'                  => esc_html__( 'Wave', 'dor' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'dor' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'dor' ),
								'atom'                  => esc_html__( 'Atom', 'dor' ),
								'clock'                 => esc_html__( 'Clock', 'dor' ),
								'mitosis'               => esc_html__( 'Mitosis', 'dor' ),
								'lines'                 => esc_html__( 'Lines', 'dor' ),
								'fussion'               => esc_html__( 'Fussion', 'dor' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'dor' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'dor' )
							)
						)
					);
					
					dor_mikado_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'mkdf_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'dor' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					dor_mikado_create_meta_box_field(
						array(
							'name'        => 'mkdf_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'dor' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'dor' ),
							'options'     => dor_mikado_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		dor_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'dor' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'dor' ),
				'parent'      => $general_meta_box,
				'options'     => dor_mikado_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'dor_mikado_action_meta_boxes_map', 'dor_mikado_map_general_meta', 10 );
}

if ( ! function_exists( 'dor_mikado_container_background_style' ) ) {
	/**
	 * Function that return container style
	 */
	function dor_mikado_container_background_style( $style ) {
		$page_id      = dor_mikado_get_page_id();
		$class_prefix = dor_mikado_get_unique_page_class( $page_id, true );
		
		$container_selector = array(
			$class_prefix . ' .mkdf-content'
		);
		
		$container_class        = array();
		$page_background_color  = get_post_meta( $page_id, 'mkdf_page_background_color_meta', true );
		$page_background_image  = get_post_meta( $page_id, 'mkdf_page_background_image_meta', true );
		$page_background_repeat = get_post_meta( $page_id, 'mkdf_page_background_repeat_meta', true );
		
		if ( ! empty( $page_background_color ) ) {
			$container_class['background-color'] = $page_background_color;
		}
		
		if ( ! empty( $page_background_image ) ) {
			$container_class['background-image'] = 'url(' . esc_url( $page_background_image ) . ')';
			
			if ( $page_background_repeat === 'yes' ) {
				$container_class['background-repeat']   = 'repeat';
				$container_class['background-position'] = '0 0';
			} else {
				$container_class['background-repeat']   = 'no-repeat';
				$container_class['background-position'] = 'center 0';
				$container_class['background-size']     = 'cover';
			}
		}
		
		$current_style = dor_mikado_dynamic_css( $container_selector, $container_class );
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'dor_mikado_filter_add_page_custom_style', 'dor_mikado_container_background_style' );
}