<?php
/* Theme-specific action to configure ThemeREX Addons components
------------------------------------------------------------------------------- */


/* ThemeREX Addons components
------------------------------------------------------------------------------- */

if (!function_exists('dixon_trx_addons_theme_specific_setup1')) {
	add_action( 'after_setup_theme', 'dixon_trx_addons_theme_specific_setup1', 1 );
	add_action( 'trx_addons_action_save_options', 'dixon_trx_addons_theme_specific_setup1', 8 );
	function dixon_trx_addons_theme_specific_setup1() {
		if (dixon_exists_trx_addons()) {
			add_filter( 'trx_addons_cv_enable',				'dixon_trx_addons_cv_enable');
			add_filter( 'trx_addons_cpt_list',				'dixon_trx_addons_cpt_list');
			add_filter( 'trx_addons_sc_list',				'dixon_trx_addons_sc_list');
			add_filter( 'trx_addons_widgets_list',			'dixon_trx_addons_widgets_list');
			add_filter( 'trx_addons_sc_title_style', 		'dixon_specific_trx_addons_sc_title_style', 10, 2);
		}
	}
}

// CV
if ( !function_exists( 'dixon_trx_addons_cv_enable' ) ) {
	
	function dixon_trx_addons_cv_enable($enable=false) {
		// To do: return false if theme not use CV functionality
		return false;
	}
}

// CPT
if ( !function_exists( 'dixon_trx_addons_cpt_list' ) ) {
	
	function dixon_trx_addons_cpt_list($list=array()) {
		// To do: Enable/Disable CPT via add/remove it in the list
		return $list;
	}
}

// Shortcodes
if ( !function_exists( 'dixon_trx_addons_sc_list' ) ) {
	
	function dixon_trx_addons_sc_list($list=array()) {
		// To do: Add/Remove shortcodes into list
		// If you add new shortcode - in the theme's folder must exists /trx_addons/shortcodes/new_sc_name/new_sc_name.php
		return $list;
	}
}

// Widgets
if ( !function_exists( 'dixon_trx_addons_widgets_list' ) ) {
	
	function dixon_trx_addons_widgets_list($list=array()) {
		// To do: Add/Remove widgets into list
		// If you add widget - in the theme's folder must exists /trx_addons/widgets/new_widget_name/new_widget_name.php
		return $list;
	}
}

if ( !function_exists( 'dixon_specific_trx_addons_sc_title_style' ) ) {
	function dixon_specific_trx_addons_sc_title_style($list, $sc='') {
		if ($sc == 'trx_sc_title') {
			$list[esc_html__('Style H3', 'dixon')] = 'h3';
		}		
		if ($sc == 'trx_sc_action') {
			$list[esc_html__('Style H3', 'dixon')] = 'h3';
		}
		if ($sc == 'trx_sc_promo') {
			$list[esc_html__('Style H3', 'dixon')] = 'h3';
		}
		return $list;
	}
}

/* Add options in the Theme Options Customizer
------------------------------------------------------------------------------- */

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('dixon_trx_addons_theme_specific_setup3')) {
	add_action( 'after_setup_theme', 'dixon_trx_addons_theme_specific_setup3', 3 );
	function dixon_trx_addons_theme_specific_setup3() {
		
		// Section 'Courses' - settings to show 'Courses' blog archive and single posts
		if (dixon_exists_courses()) {
			dixon_storage_merge_array('options', '', array(
				'courses' => array(
					"title" => esc_html__('Courses', 'dixon'),
					"desc" => wp_kses_data( __('Select parameters to display the courses pages', 'dixon') ),
					"type" => "section"
					),
				'expand_content_courses' => array(
					"title" => esc_html__('Expand content', 'dixon'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'dixon') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
				'header_style_courses' => array(
					"title" => esc_html__('Header style', 'dixon'),
					"desc" => wp_kses_data( __('Select style to display the site header on the courses pages', 'dixon') ),
					"std" => 'inherit',
					"options" => dixon_get_list_header_styles(true),
					"type" => "select"
					),
				'header_position_courses' => array(
					"title" => esc_html__('Header position', 'dixon'),
					"desc" => wp_kses_data( __('Select position to display the site header on the courses pages', 'dixon') ),
					"std" => 'inherit',
					"options" => dixon_get_list_header_positions(true),
					"type" => "select"
					),
				'header_widgets_courses' => array(
					"title" => esc_html__('Header widgets', 'dixon'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on the courses pages', 'dixon') ),
					"std" => 'hide',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'sidebar_widgets_courses' => array(
					"title" => esc_html__('Sidebar widgets', 'dixon'),
					"desc" => wp_kses_data( __('Select sidebar to show on the courses pages', 'dixon') ),
					"std" => 'courses_widgets',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'sidebar_position_courses' => array(
					"title" => esc_html__('Sidebar position', 'dixon'),
					"desc" => wp_kses_data( __('Select position to show sidebar on the courses pages', 'dixon') ),
					"refresh" => false,
					"std" => 'left',
					"options" => dixon_get_list_sidebars_positions(true),
					"type" => "select"
					),
				'hide_sidebar_on_single_courses' => array(
					"title" => esc_html__('Hide sidebar on the single course', 'dixon'),
					"desc" => wp_kses_data( __("Hide sidebar on the single course's page", 'dixon') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'widgets_above_page_courses' => array(
					"title" => esc_html__('Widgets above the page', 'dixon'),
					"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'dixon') ),
					"std" => 'hide',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'widgets_above_content_courses' => array(
					"title" => esc_html__('Widgets above the content', 'dixon'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'dixon') ),
					"std" => 'hide',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'widgets_below_content_courses' => array(
					"title" => esc_html__('Widgets below the content', 'dixon'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'dixon') ),
					"std" => 'hide',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'widgets_below_page_courses' => array(
					"title" => esc_html__('Widgets below the page', 'dixon'),
					"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'dixon') ),
					"std" => 'hide',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'footer_scheme_courses' => array(
					"title" => esc_html__('Footer Color Scheme', 'dixon'),
					"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'dixon') ),
					"std" => 'dark',
					"options" => dixon_get_list_schemes(true),
					"type" => "select"
					),
				'footer_widgets_courses' => array(
					"title" => esc_html__('Footer widgets', 'dixon'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'dixon') ),
					"std" => 'footer_widgets',
					"options" => dixon_get_list_sidebars(true, true),
					"type" => "select"
					),
				'footer_columns_courses' => array(
					"title" => esc_html__('Footer columns', 'dixon'),
					"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'dixon') ),
					"dependency" => array(
						'footer_widgets_courses' => array('^hide')
					),
					"std" => 0,
					"options" => dixon_get_list_range(0,6),
					"type" => "select"
					),
				'footer_wide_courses' => array(
					"title" => esc_html__('Footer fullwide', 'dixon'),
					"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'dixon') ),
					"std" => 0,
					"type" => "checkbox"
					)
				)
			);
		}
	}
}

// Add mobile menu to the plugin's cached menu list
if ( !function_exists( 'dixon_trx_addons_menu_cache' ) ) {
	add_filter( 'trx_addons_filter_menu_cache', 'dixon_trx_addons_menu_cache');
	function dixon_trx_addons_menu_cache($list=array()) {
		if (in_array('#menu_main', $list)) $list[] = '#menu_mobile';
		return $list;
	}
}

// Add vars into localize array
if (!function_exists('dixon_trx_addons_localize_script')) {
	add_filter( 'dixon_filter_localize_script','dixon_trx_addons_localize_script' );
	function dixon_trx_addons_localize_script($arr) {
		$arr['text_link_color'] = dixon_get_scheme_color('text_link');
		return $arr;
	}
}


// Add theme-specific layouts to the list
if (!function_exists('dixon_trx_addons_theme_specific_default_layouts')) {
	add_filter( 'trx_addons_filter_default_layouts',	'dixon_trx_addons_theme_specific_default_layouts');
	function dixon_trx_addons_theme_specific_default_layouts($default_layouts=array()) {
		require_once 'trx_addons.layouts.php';
		return isset($layouts) && is_array($layouts) && count($layouts) > 0
						? array_merge($default_layouts, $layouts)
						: $default_layouts;
	}
}

// Disable override header image on team pages
if ( !function_exists( 'dixon_trx_addons_allow_override_header_image' ) ) {
	add_filter( 'dixon_filter_allow_override_header_image', 'dixon_trx_addons_allow_override_header_image' );
	function dixon_trx_addons_allow_override_header_image($allow) {
		return dixon_is_team_page() || dixon_is_portfolio_page() ? false : $allow;
	}
}

// Hide sidebar on the team pages
if ( !function_exists( 'dixon_trx_addons_sidebar_present' ) ) {
	add_filter( 'dixon_filter_sidebar_present', 'dixon_trx_addons_sidebar_present' );
	function dixon_trx_addons_sidebar_present($present) {
		return !is_single() && (dixon_is_team_page() || dixon_is_portfolio_page()) ? false : $present;
	}
}


// WP Editor addons
//------------------------------------------------------------------------

// Theme-specific configure of the WP Editor
if ( !function_exists( 'dixon_trx_addons_editor_init' ) ) {
	if (is_admin()) add_filter( 'tiny_mce_before_init', 'dixon_trx_addons_editor_init', 11);
	function dixon_trx_addons_editor_init($opt) {
		if (dixon_exists_trx_addons()) {
			// Add style 'Arrow' to the 'List styles'
			// Remove 'false &&' from condition below to add new style to the list
			if (!empty($opt['style_formats'])) {
				$style_formats = json_decode($opt['style_formats'], true);
				if (is_array($style_formats) && count($style_formats)>0 ) {
					unset($style_formats[2]['items'][1]); // Custom
					unset($style_formats[2]['items'][2]); // Parameters
					unset($style_formats[2]['items'][4]); // Error
					unset($style_formats[2]['items'][5]); // Info
					unset($style_formats[2]['items'][6]); // Plus
					unset($style_formats[2]['items'][7]); // Minus
					unset($style_formats[2]['items'][8]); // Help
					unset($style_formats[2]['items'][9]); // Attention
					unset($style_formats[2]['items'][10]); // Success (circled)
					unset($style_formats[2]['items'][11]); // Error (circled)
					unset($style_formats[2]['items'][12]); // Info (circled)
					unset($style_formats[2]['items'][13]); // Plus (circled)
					unset($style_formats[2]['items'][14]); // Minus (circled)
					unset($style_formats[2]['items'][15]); // Help (circled)
					unset($style_formats[2]['items'][16]); // Attention (circled)
					
					$opt['style_formats'] = json_encode( $style_formats );		
				}
			}
		}
		return $opt;
	}
}

// Theme-specific thumb sizes
//------------------------------------------------------------------------

// Replace thumb sizes to the theme-specific
if ( !function_exists( 'dixon_trx_addons_add_thumb_sizes' ) ) {
	add_filter( 'trx_addons_filter_add_thumb_sizes', 'dixon_trx_addons_add_thumb_sizes');
	function dixon_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry-big',
								'trx_addons-thumb-masonry',
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// Return theme-specific thumb size instead removed plugin's thumb size
if ( !function_exists( 'dixon_trx_addons_get_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_get_thumb_size', 'dixon_trx_addons_get_thumb_size');
	function dixon_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-avatar',
							'trx_addons-thumb-avatar-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							),
							array(
							'dixon-thumb-huge',
							'dixon-thumb-huge-@retina',
							'dixon-thumb-big',
							'dixon-thumb-big-@retina',
							'dixon-thumb-med',
							'dixon-thumb-med-@retina',
							'dixon-thumb-tiny',
							'dixon-thumb-tiny-@retina',
							'dixon-thumb-avatar',
							'dixon-thumb-avatar-@retina',
							'dixon-thumb-masonry-big',
							'dixon-thumb-masonry-big-@retina',
							'dixon-thumb-masonry',
							'dixon-thumb-masonry-@retina',
							),
							$thumb_size);
	}
}

// Get thumb size for the team items
if ( !function_exists( 'dixon_trx_addons_team_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_team_thumb_size',	'dixon_trx_addons_team_thumb_size', 10, 2);
	function dixon_trx_addons_team_thumb_size($thumb_size='', $team_type='') {
		return $team_type == 'default' ? dixon_get_thumb_size('med') : $thumb_size;
	}
}



// Shortcodes support
//------------------------------------------------------------------------

// Return tag for the item's title
if ( !function_exists( 'dixon_trx_addons_sc_item_title_tag' ) ) {
	add_filter( 'trx_addons_filter_sc_item_title_tag', 'dixon_trx_addons_sc_item_title_tag');
	function dixon_trx_addons_sc_item_title_tag($tag='') {
		return $tag=='h1' ? 'h2' : $tag;
	}
}

// Return args for the item's button
if ( !function_exists( 'dixon_trx_addons_sc_item_button_args' ) ) {
	add_filter( 'trx_addons_filter_sc_item_button_args', 'dixon_trx_addons_sc_item_button_args');
	function dixon_trx_addons_sc_item_button_args($args, $sc='') {
		if (false && $sc != 'sc_button') {
			$args['type'] = 'simple';
			$args['icon_type'] = 'fontawesome';
			$args['icon_fontawesome'] = 'icon-down-big';
			$args['icon_position'] = 'top';
		}
		return $args;
	}
}

// Add new types in the shortcodes
if ( !function_exists( 'dixon_trx_addons_sc_type' ) ) {
	add_filter( 'trx_addons_sc_type', 'dixon_trx_addons_sc_type', 10, 2);
	function dixon_trx_addons_sc_type($list, $sc) {
		return $list;
	}
}

// Add new styles to the Google map
if ( !function_exists( 'dixon_trx_addons_sc_googlemap_styles' ) ) {
	add_filter( 'trx_addons_filter_sc_googlemap_styles',	'dixon_trx_addons_sc_googlemap_styles');
	function dixon_trx_addons_sc_googlemap_styles($list) {
		$list[esc_html__('Dark', 'dixon')] = 'dark';
		return $list;
	}
}

// Remove some style from editor
if ( !function_exists( 'dixon_specific_trx_addons_editor_init' ) ) {
	function dixon_specific_trx_addons_editor_init($opt) {

		return $opt;
	}
}

