<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)

if ( !function_exists('dixon_options_theme_setup1') ) {
	add_action( 'after_setup_theme', 'dixon_options_theme_setup1', 1 );
	function dixon_options_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		dixon_storage_set('settings', array(
			
			'ajax_views_counter'		=> true,						// Use AJAX for increment posts counter (if cache plugins used) 
																		// or increment posts counter then loading page (without cache plugin)
			'disable_jquery_ui'			=> false,						// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'max_load_fonts'			=> 3,							// Max fonts number to load from Google fonts or from uploaded fonts
		
			'use_mediaelements'			=> true,						// Load script "Media Elements" to play video and audio
		
			'max_excerpt_length'		=> 60,							// Max words number for the excerpt in the blog style 'Excerpt'.
																		// For style 'Classic' - get half from this value
			'message_maxlength'			=> 1000							// Max length of the message from contact form
			
		));
		
		
		
		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		dixon_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Cormorant SC',
				'family' => 'serif',
				'styles' => '300,400,500,600,700'		// Parameter 'style' used only for the Google fonts
				),
			array(
				'name'	 => 'Oxygen',
				'family' => 'sans-serif',
				'styles' => '300,400,700'		// Parameter 'style' used only for the Google fonts
				),
			array(
				'name'	 => 'Cabin',
				'family' => 'sans-serif',
				'styles' => '400,400i,500,500i,600,600i,700,700i'		// Parameter 'style' used only for the Google fonts
				)
			// Font-face packed with theme
			
			
			
			
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		dixon_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		dixon_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'dixon'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'dixon'),
				'font-family'		=> 'Cabin, sans-serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.375em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.4em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '3.75rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0',
				'margin-top'		=> '0.9583em',
				'margin-bottom'		=> '0.29em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '3rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1111em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0',
				'margin-top'		=> '1.0444em',
				'margin-bottom'		=> '0.54em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '2.25rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1515em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0',
				'margin-top'		=> '1.3333em',
				'margin-bottom'		=> '0.7879em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '1.875rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3043em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0',
				'margin-top'		=> '1.9565em',
				'margin-bottom'		=> '0.3em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '1.5rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.35em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.5em',
				'margin-bottom'		=> '0.41em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '1.125rem',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.4706em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '2.1176em',
				'margin-bottom'		=> '0.4em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'dixon'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '1.8em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.4px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'dixon'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'dixon'),
				'font-family'		=> 'Cabin, sans-serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '16px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'dixon'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.875rem',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0',
				'margin-top'		=> '',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'dixon'),
				'description'		=> esc_html__('Font settings of the main menu items', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '16px',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'dixon'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'dixon'),
				'font-family'		=> 'Cormorant SC, serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		dixon_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'dixon'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#ffffff',
					'bd_color'				=> '#e3e3e3',
		
					// Text and links colors
					'text'					=> '#6b6b6b',
					'text_light'			=> '#b3b3b3',
					'text_dark'				=> '#1a1818',
					'text_link'				=> '#c71010',
					'text_hover'			=> '#a70505',
		
					// Alternative blocks (submenu, buttons, tabs, etc.)
					'alter_bg_color'		=> '#f6f6f6',
					'alter_bg_hover'		=> '#e3e3e3',
					'alter_bd_color'		=> '#1b151f',
					'alter_bd_hover'		=> '#4a434f',
					'alter_text'			=> '#a3a3a3',
					'alter_light'			=> '#8b8a8d',
					'alter_dark'			=> '#737373',
					'alter_link'			=> '#bf2d0d',
					'alter_hover'			=> '#72cfd5',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#f7f7f7',
					'input_bg_hover'		=> '#e3e3e3',
					'input_bd_color'		=> '#e7eaed',
					'input_bd_hover'		=> '#e0e0e0',
					'input_text'			=> '#737373',
					'input_light'			=> '#e5e5e5',
					'input_dark'			=> '#1d1d1d',
					
					// Inverse blocks (text and links on accented bg)
					'inverse_text'			=> '#1d1d1d',
					'inverse_light'			=> '#333333',
					'inverse_dark'			=> '#ffffff',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#1d1d1d',
		
					// Additional accented colors (if used in the current theme)
					
					'accent1'				=> '#c71010',
					'accent2'				=> '#251d2b'
				
				)
			),
			// Color scheme: 'Grey'
			'grey' => array(
				'title'	 => esc_html__('Grey', 'dixon'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#f6f6f6',
					'bd_color'				=> '#e3e3e3',
		
					// Text and links colors
					'text'					=> '#6b6b6b',
					'text_light'			=> '#b3b3b3',
					'text_dark'				=> '#1a1818',
					'text_link'				=> '#c71010',
					'text_hover'			=> '#a70505',
		
					// Alternative blocks (submenu, buttons, tabs, etc.)
					'alter_bg_color'		=> '#f6f6f6',
					'alter_bg_hover'		=> '#e3e3e3',
					'alter_bd_color'		=> '#e5e5e5',
					'alter_bd_hover'		=> '#dadada',
					'alter_text'			=> '#a3a3a3',
					'alter_light'			=> '#8b8a8d',
					'alter_dark'			=> '#737373',
					'alter_link'			=> '#bf2d0d',
					'alter_hover'			=> '#72cfd5',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#f7f7f7',
					'input_bg_hover'		=> '#e3e3e3',
					'input_bd_color'		=> '#e7eaed',
					'input_bd_hover'		=> '#e0e0e0',
					'input_text'			=> '#737373',
					'input_light'			=> '#e5e5e5',
					'input_dark'			=> '#1d1d1d',
					
					// Inverse blocks (text and links on accented bg)
					'inverse_text'			=> '#1d1d1d',
					'inverse_light'			=> '#333333',
					'inverse_dark'			=> '#ffffff',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#1d1d1d',
		
					// Additional accented colors (if used in the current theme)
					
					'accent1'				=> '#c71010',
					'accent2'				=> '#251d2b'
				
				)
			),		
			// Color scheme: 'Menu'
			'menu' => array(
				'title'	 => esc_html__('Menu', 'dixon'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#1b151f',
					'bd_color'				=> '#1b151f', 
		
					// Text and links colors
					'text'					=> '#ffffff',
					'text_light'			=> '#c2c2c2',
					'text_dark'				=> '#1a1818',
					'text_link'				=> '#c71010',
					'text_hover'			=> '#c71010',
		
					// Alternative blocks (submenu, buttons, tabs, etc.)
					'alter_bg_color'		=> '#f7f7f7',
					'alter_bg_hover'		=> '#f7f7f7', 
					'alter_bd_color'		=> '#313131',
					'alter_bd_hover'		=> '#3d3d3d',
					'alter_text'			=> '#a6a6a6',
					'alter_light'			=> '#5f5f5f',
					'alter_dark'			=> '#ffffff',
					'alter_link'			=> '#c71010',
					'alter_hover'			=> '#fe7259',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#2e2d32',
					'input_bg_hover'		=> '#2e2d32',
					'input_bd_color'		=> '#ffffff',
					'input_bd_hover'		=> '#353535',
					'input_text'			=> '#b7b7b7',
					'input_light'			=> '#5f5f5f',
					'input_dark'			=> '#ffffff',
					
					// Inverse blocks (text and links on accented bg)
					'inverse_text'			=> '#1d1d1d',
					'inverse_light'			=> '#5f5f5f',
					'inverse_dark'			=> '#ffffff',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#1d1d1d',
				
					// Additional accented colors (if used in the current theme)
					
					'accent1'				=> '#c71010',
					'accent2'				=> '#2c2730'
				
				)
			),		
			// Color scheme: 'Sidemenu'
			'sidemenu' => array(
				'title'	 => esc_html__('Sidemenu', 'dixon'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#000000',
					'bd_color'				=> '#acacac',
		
					// Text and links colors
					'text'					=> '#ffffff',
					'text_light'			=> '#c2c2c2',
					'text_dark'				=> '#1a1818',
					'text_link'				=> '#a70505',
					'text_hover'			=> '#a70505',
		
					// Alternative blocks (submenu, buttons, tabs, etc.)
					'alter_bg_color'		=> '#f7f7f7',
					'alter_bg_hover'		=> '#000000',
					'alter_bd_color'		=> '#313131',
					'alter_bd_hover'		=> '#3d3d3d',
					'alter_text'			=> '#a6a6a6',
					'alter_light'			=> '#5f5f5f',
					'alter_dark'			=> '#ffffff',
					'alter_link'			=> '#c71010',
					'alter_hover'			=> '#c71010',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#2e2d32',
					'input_bg_hover'		=> '#2e2d32',
					'input_bd_color'		=> '#ffffff',
					'input_bd_hover'		=> '#353535',
					'input_text'			=> '#b7b7b7',
					'input_light'			=> '#5f5f5f',
					'input_dark'			=> '#ffffff',
					
					// Inverse blocks (text and links on accented bg)
					'inverse_text'			=> '#1d1d1d',
					'inverse_light'			=> '#5f5f5f',
					'inverse_dark'			=> '#ffffff',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#1d1d1d',
				
					// Additional accented colors (if used in the current theme)
					
					'accent1'				=> '#c71010',
					'accent2'				=> '#2c2730'
				
				)
			),	
			// Color scheme: 'dark'
			'lilac' => array(
				'title'  => esc_html__('Lilac', 'dixon'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#1b151f',
					'bd_color'				=> '#3a353d',
		
					// Text and links colors
					'text'					=> '#a5a5a5',
					'text_light'			=> '#ffffff',
					'text_dark'				=> '#ffffff',
					'text_link'				=> '#c71010',
					'text_hover'			=> '#a70505',
		
					// Alternative blocks (submenu, buttons, tabs, etc.)
					'alter_bg_color'		=> '#251d2b',
					'alter_bg_hover'		=> '#28272e',
					'alter_bd_color'		=> '#313131',
					'alter_bd_hover'		=> '#3d3d3d',
					'alter_text'			=> '#a6a6a6',
					'alter_light'			=> '#b7b7b7',
					'alter_dark'			=> '#acacac',
					'alter_link'			=> '#c71010',
					'alter_hover'			=> '#fe7259',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#362e3b',
					'input_bg_hover'		=> '#3f3744',
					'input_bd_color'		=> '#e7eaed',
					'input_bd_hover'		=> '#e0e0e0',
					'input_text'			=> '#9f9ca2',
					'input_light'			=> '#e5e5e5',
					'input_dark'			=> '#9f9ca2',
					
					// Inverse blocks (text and links on accented bg)
					'inverse_text'			=> '#1d1d1d',
					'inverse_light'			=> '#5f5f5f',
					'inverse_dark'			=> '#ffffff',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#1d1d1d',
				
					// Additional accented colors (if used in the current theme)
					
					'accent1'				=> '#ffffff',
					'accent2'				=> '#2c2730'
		
				)
			),	
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'dixon'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'				=> '#1b151f',
					'bd_color'				=> '#3a353d',
		
					// Text and links colors
					'text'					=> '#8b8a8d',
					'text_light'			=> '#ffffff',
					'text_dark'				=> '#ffffff',
					'text_link'				=> '#c71010',
					'text_hover'			=> '#a70505',
		
					// Alternative blocks (submenu, buttons, tabs, etc.)
					'alter_bg_color'		=> '#251d2b',
					'alter_bg_hover'		=> '#28272e',
					'alter_bd_color'		=> '#313131',
					'alter_bd_hover'		=> '#3d3d3d',
					'alter_text'			=> '#a6a6a6',
					'alter_light'			=> '#b7b7b7',
					'alter_dark'			=> '#acacac',
					'alter_link'			=> '#c71010',
					'alter_hover'			=> '#fe7259',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'		=> '#f7f7f7',
					'input_bg_hover'		=> '#e3e3e3',
					'input_bd_color'		=> '#e7eaed',
					'input_bd_hover'		=> '#e0e0e0',
					'input_text'			=> '#737373',
					'input_light'			=> '#e5e5e5',
					'input_dark'			=> '#1d1d1d',
					
					// Inverse blocks (text and links on accented bg)
					'inverse_text'			=> '#1d1d1d',
					'inverse_light'			=> '#5f5f5f',
					'inverse_dark'			=> '#ffffff',
					'inverse_link'			=> '#ffffff',
					'inverse_hover'			=> '#1d1d1d',
				
					// Additional accented colors (if used in the current theme)
					
					'accent1'				=> '#c71010',
					'accent2'				=> '#2c2730'
		
				)
			)
		
		));
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('dixon_options_create')) {

	function dixon_options_create() {

		dixon_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'dixon'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'dixon') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'dixon') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'dixon'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'dixon'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'dixon'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'dixon'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 'header-default',
				"options" => dixon_get_list_header_styles(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'dixon'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 'default',
				"options" => dixon_get_list_header_positions(),
				"type" => "select"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'dixon') ),
				),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'dixon'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"dependency" => array(
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => dixon_get_list_range(0,6),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'dixon'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 'menu',
				"options" => dixon_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_info' => array(
				"title" => esc_html__('Menu settings', 'dixon'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'dixon') ),
				"type" => "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'dixon'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'dixon'),
					'right'	=> esc_html__('Right',	'dixon')
				),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'dixon'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => 'menu',
				"options" => dixon_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'dixon'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'dixon') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'dixon'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'dixon') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'dixon'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'dixon') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo settings', 'dixon'),
				"desc" => wp_kses_data( __('Select logo images for the normal and Retina displays', 'dixon') ),
				"type" => "info"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse' => array(
				"title" => esc_html__('Logo inverse', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it on the dark background', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse_retina' => array(
				"title" => esc_html__('Logo inverse for Retina', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'logo_text' => array(
				"title" => esc_html__('Logo from Site name', 'dixon'),
				"desc" => wp_kses_data( __('Do you want use Site name and description as Logo if images above are not selected?', 'dixon') ),
				"std" => 1,
				"type" => "checkbox"
				),
			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'dixon'),
				"desc" => wp_kses_data( __('Options for the content area', 'dixon') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'dixon'),
				"desc" => wp_kses_data( __('Select width of the body content', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'dixon'),
					'wide'		=> esc_html__('Wide',		'dixon')
				),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'dixon'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"std" => 'default',
				"options" => dixon_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'dixon'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'dixon')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'dixon'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'dixon')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'dixon'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'dixon') ),
				"std" => 0,
				"type" => "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'dixon'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'dixon') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'dixon'), 'dixon_kses_content' ),
                "type"  => "text"
            ),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'dixon'),
				"desc" => wp_kses_data( __('Specify the border radius of the form fields and buttons in pixels or other valid CSS units', 'dixon') ),
				"std" => 0,
				"type" => "text"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'dixon') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"std" => '',
				"type" => "image"
				),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'dixon') ),
				"std" => '',
				"type" => "image"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"std" => 'sidebar_widgets',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'dixon'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"std" => 'inherit',
				"options" => dixon_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'dixon'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => dixon_get_list_sidebars_positions(),
				"type" => "select"
				),
			'hide_sidebar_on_single' => array(
				"title" => esc_html__('Hide sidebar on the single post', 'dixon'),
				"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'dixon') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets above the page', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets below the page', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'dixon')
				),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'dixon'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'dixon') ),
				"type" => "section"
				),
			'footer_style' => array(
				"title" => esc_html__('Footer style', 'dixon'),
				"desc" => wp_kses_data( __('Select style to display the site footer', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'dixon')
				),
				"std" => 'footer-default',
				"options" => apply_filters('dixon_filter_list_footer_styles', array(
					'footer-default' => esc_html__('Default Footer',	'dixon')
				)),
				"type" => "select"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'dixon'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'dixon')
				),
				"std" => 'dark',
				"options" => dixon_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'dixon')
				),
				"std" => 'footer_widgets',
				"options" => dixon_get_list_sidebars(false, true),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'dixon'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'dixon')
				),
				"dependency" => array(
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => dixon_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'dixon'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'dixon') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'dixon')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'dixon'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'dixon') ),
				'refresh' => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'dixon') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'dixon'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'dixon') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'dixon'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'dixon') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'dixon'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'dixon') ),
				"std" => esc_html__('ThemeREX &copy; {Y}. All rights reserved. Terms of use and Privacy Policy', 'dixon'),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'dixon'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'dixon') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'dixon'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'dixon') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'dixon'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'dixon') ),
				"std" => 'excerpt',
				"options" => dixon_get_list_blog_styles(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'dixon'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'dixon') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style_home' => array(
				"title" => esc_html__('Header style', 'dixon'),
				"desc" => wp_kses_data( __('Select style to display the site header on the homepage', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_header_styles(true),
				"type" => "select"
				),
			'header_position_home' => array(
				"title" => esc_html__('Header position', 'dixon'),
				"desc" => wp_kses_data( __('Select position to display the site header on the homepage', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_header_positions(true),
				"type" => "select"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'dixon') ),
				"std" => 'header_widgets',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'dixon'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'dixon') ),
				"refresh" => false,
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars_positions(true),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'dixon') ),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'dixon') ),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'dixon') ),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'dixon') ),
				"std" => 'hide',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'dixon'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'dixon') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'dixon'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'dixon') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'dixon'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' )
				),
				"std" => 'excerpt',
				"options" => dixon_get_list_blog_styles(),
				"type" => "select"
				),
			'blog_columns' => array(
				"title" => esc_html__('Blog columns', 'dixon'),
				"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'dixon') ),
				"std" => 2,
				"options" => dixon_get_list_range(2,4),
				"type" => "hidden"
				),
			'post_type' => array(
				"title" => esc_html__('Post type', 'dixon'),
				"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' )
				),
				"linked" => 'parent_cat',
				"refresh" => false,
				"hidden" => true,
				"std" => 'post',
				"options" => dixon_get_list_posts_types(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'dixon'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' )
				),
				"refresh" => false,
				"hidden" => true,
				"std" => '0',
				"options" => dixon_array_merge(array(0 => esc_html__('- Select category -', 'dixon')), dixon_get_list_categories()),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'dixon'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' )
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'dixon'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"std" => "links",
				"options" => array(
					'pages'	=> esc_html__("Page numbers", 'dixon'),
					'links'	=> esc_html__("Older/Newest", 'dixon'),
					'more'	=> esc_html__("Load more", 'dixon'),
					'infinite' => esc_html__("Infinite scroll", 'dixon')
				),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'dixon'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'dixon'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'dixon') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'dixon'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'dixon') ),
				"std" => "excerpt",
				"options" => array(
					'excerpt'	=> esc_html__('Excerpt',	'dixon'),
					'fullpost'	=> esc_html__('Full post',	'dixon')
				),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'dixon'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'dixon') ),
				"std" => 5,
				"type" => "text"
				),
			'related_posts' => array(
				"title" => esc_html__('Related posts', 'dixon'),
				"desc" => wp_kses_data( __('How many related posts should be displayed in the single post?', 'dixon') ),
				"std" => 2,
				"options" => dixon_get_list_range(2,4),
				"type" => "select"
				),
			'related_style' => array(
				"title" => esc_html__('Related posts style', 'dixon'),
				"desc" => wp_kses_data( __('Select style of the related posts output', 'dixon') ),
				"std" => 2,
				"options" => dixon_get_list_styles(1,2),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for the posts', 'dixon'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'dixon')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' )
				),
				"std" => "none",
				"options" => dixon_get_list_animations_in(),
				"type" => "select"
				),
			'header_style_blog' => array(
				"title" => esc_html__('Header style', 'dixon'),
				"desc" => wp_kses_data( __('Select style to display the site header on the blog archive', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_header_styles(true),
				"type" => "select"
				),
			'header_position_blog' => array(
				"title" => esc_html__('Header position', 'dixon'),
				"desc" => wp_kses_data( __('Select position to display the site header on the blog archive', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_header_positions(true),
				"type" => "select"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'dixon'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'dixon'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'dixon') ),
				"refresh" => false,
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars_positions(true),
				"type" => "select"
				),
			'hide_sidebar_on_single_blog' => array(
				"title" => esc_html__('Hide sidebar on the single post', 'dixon'),
				"desc" => wp_kses_data( __("Hide sidebar on the single post", 'dixon') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'dixon'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'dixon') ),
				"std" => 'inherit',
				"options" => dixon_get_list_sidebars(true, true),
				"type" => "select"
				),
			
		
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('* Color scheme editor', 'dixon'),
				"desc" => wp_kses_data( __("<b>Simple settings</b> - you can change only accented color, used for links, buttons and some accented areas.", 'dixon') )
						. '<br>'
						. wp_kses_data( __("<b>Advanced settings</b> - change all scheme's colors and get full control over the appearance of your site!", 'dixon') ),
				"priority" => 1000,
				"type" => "section"
				),
		
			'color_settings' => array(
				"title" => esc_html__('Color settings', 'dixon'),
				"desc" => '',
				"std" => 'simple',
				"options" => array(
					"simple"  => esc_html__("Simple", 'dixon'),
					"advanced" => esc_html__("Advanced", 'dixon')
				),
				"refresh" => false,
				"type" => "switch"
				),
		
			'color_scheme_editor' => array(
				"title" => esc_html__('Color Scheme', 'dixon'),
				"desc" => wp_kses_data( __('Select color scheme to edit colors', 'dixon') ),
				"std" => 'default',
				"options" => dixon_get_list_schemes(),
				"refresh" => false,
				"type" => "select"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Colors storage', 'dixon'),
				"desc" => esc_html__('Hidden storage of the all color from the all color shemes (only for internal usage)', 'dixon'),
				"std" => '',
				"refresh" => false,
				"type" => "hidden"
				),
			'scheme_info_accent' => array(
				"title" => esc_html__('Accent colors', 'dixon'),
				"desc" => wp_kses_data( __('Accent colors', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
			'accent1' => array(
				"title" => esc_html__('Accent color 1', 'dixon'),
				"desc" => wp_kses_data( __('Accent color 1', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),		
			'accent2' => array(
				"title" => esc_html__('Accent color 2', 'dixon'),
				"desc" => wp_kses_data( __('Accent color 2', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),		
			'scheme_info_single' => array(
				"title" => esc_html__('Colors for single post/page', 'dixon'),
				"desc" => wp_kses_data( __('Specify colors for single post/page (not for alter blocks)', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
				
			'bg_color' => array(
				"title" => esc_html__('Background color', 'dixon'),
				"desc" => wp_kses_data( __('Background color of the whole page', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'bd_color' => array(
				"title" => esc_html__('Border color', 'dixon'),
				"desc" => wp_kses_data( __('Color of the bordered elements, separators, etc.', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'text' => array(
				"title" => esc_html__('Text', 'dixon'),
				"desc" => wp_kses_data( __('Plain text color on single page/post', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_light' => array(
				"title" => esc_html__('Light text', 'dixon'),
				"desc" => wp_kses_data( __('Color of the post meta: post date and author, comments number, etc.', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_dark' => array(
				"title" => esc_html__('Dark text', 'dixon'),
				"desc" => wp_kses_data( __('Color of the headers, strong text, etc.', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_link' => array(
				"title" => esc_html__('Links', 'dixon'),
				"desc" => wp_kses_data( __('Color of links and accented areas', 'dixon') ),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_hover' => array(
				"title" => esc_html__('Links hover', 'dixon'),
				"desc" => wp_kses_data( __('Hover color for links and accented areas', 'dixon') ),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_alter' => array(
				"title" => esc_html__('Colors for alternative blocks', 'dixon'),
				"desc" => wp_kses_data( __('Specify colors for alternative blocks - rectangular blocks with its own background color (posts in homepage, blog archive, search results, widgets on sidebar, footer, etc.)', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'alter_bg_color' => array(
				"title" => esc_html__('Alter background color', 'dixon'),
				"desc" => wp_kses_data( __('Background color of the alternative blocks', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bg_hover' => array(
				"title" => esc_html__('Alter hovered background color', 'dixon'),
				"desc" => wp_kses_data( __('Background color for the hovered state of the alternative blocks', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_color' => array(
				"title" => esc_html__('Alternative border color', 'dixon'),
				"desc" => wp_kses_data( __('Border color of the alternative blocks', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_hover' => array(
				"title" => esc_html__('Alternative hovered border color', 'dixon'),
				"desc" => wp_kses_data( __('Border color for the hovered state of the alter blocks', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_text' => array(
				"title" => esc_html__('Alter text', 'dixon'),
				"desc" => wp_kses_data( __('Text color of the alternative blocks', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_light' => array(
				"title" => esc_html__('Alter light', 'dixon'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with alternative background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_dark' => array(
				"title" => esc_html__('Alter dark', 'dixon'),
				"desc" => wp_kses_data( __('Color of the headers inside block with alternative background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_link' => array(
				"title" => esc_html__('Alter link', 'dixon'),
				"desc" => wp_kses_data( __('Color of the links inside block with alternative background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_hover' => array(
				"title" => esc_html__('Alter hover', 'dixon'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with alternative background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_input' => array(
				"title" => esc_html__('Colors for the form fields', 'dixon'),
				"desc" => wp_kses_data( __('Specify colors for the form fields and textareas', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'input_bg_color' => array(
				"title" => esc_html__('Inactive background', 'dixon'),
				"desc" => wp_kses_data( __('Background color of the inactive form fields', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bg_hover' => array(
				"title" => esc_html__('Active background', 'dixon'),
				"desc" => wp_kses_data( __('Background color of the focused form fields', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_color' => array(
				"title" => esc_html__('Inactive border', 'dixon'),
				"desc" => wp_kses_data( __('Color of the border in the inactive form fields', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_hover' => array(
				"title" => esc_html__('Active border', 'dixon'),
				"desc" => wp_kses_data( __('Color of the border in the focused form fields', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_text' => array(
				"title" => esc_html__('Inactive field', 'dixon'),
				"desc" => wp_kses_data( __('Color of the text in the inactive fields', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_light' => array(
				"title" => esc_html__('Disabled field', 'dixon'),
				"desc" => wp_kses_data( __('Color of the disabled field', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_dark' => array(
				"title" => esc_html__('Active field', 'dixon'),
				"desc" => wp_kses_data( __('Color of the active field', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_inverse' => array(
				"title" => esc_html__('Colors for inverse blocks', 'dixon'),
				"desc" => wp_kses_data( __('Specify colors for inverse blocks, rectangular blocks with background color equal to the links color or one of accented colors (if used in the current theme)', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'inverse_text' => array(
				"title" => esc_html__('Inverse text', 'dixon'),
				"desc" => wp_kses_data( __('Color of the text inside block with accented background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_light' => array(
				"title" => esc_html__('Inverse light', 'dixon'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with accented background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_dark' => array(
				"title" => esc_html__('Inverse dark', 'dixon'),
				"desc" => wp_kses_data( __('Color of the headers inside block with accented background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_link' => array(
				"title" => esc_html__('Inverse link', 'dixon'),
				"desc" => wp_kses_data( __('Color of the links inside block with accented background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_hover' => array(
				"title" => esc_html__('Inverse hover', 'dixon'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with accented background', 'dixon') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$dixon_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),


			// Section 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'dixon'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'dixon') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'dixon')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'dixon'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'dixon') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'dixon')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// Panel 'Fonts' - manage fonts loading and set parameters of the base theme elements
			'fonts' => array(
				"title" => esc_html__('* Fonts settings', 'dixon'),
				"desc" => '',
				"priority" => 1500,
				"type" => "panel"
				),

			// Section 'Load_fonts'
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'dixon'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'dixon') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'dixon') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'dixon'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'dixon') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'dixon') ),
				"refresh" => false,
				"std" => '$dixon_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=dixon_get_theme_setting('max_load_fonts'); $i++) {
			$fonts["load_fonts-{$i}-info"] = array(
				"title" => esc_html(sprintf(esc_html__('Font %s', 'dixon'), $i)),
				"desc" => '',
				"type" => "info",
				);
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'dixon'),
				"desc" => '',
				"refresh" => false,
				"std" => '$dixon_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'dixon'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'dixon') )
							: '',
				"refresh" => false,
				"std" => '$dixon_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'dixon'),
					'serif' => esc_html__('serif', 'dixon'),
					'sans-serif' => esc_html__('sans-serif', 'dixon'),
					'monospace' => esc_html__('monospace', 'dixon'),
					'cursive' => esc_html__('cursive', 'dixon'),
					'fantasy' => esc_html__('fantasy', 'dixon')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'dixon'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'dixon') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'dixon') )
							: '',
				"refresh" => false,
				"std" => '$dixon_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Sections with font's attributes for each theme element
		$theme_fonts = dixon_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(esc_html__('%s settings', 'dixon'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses_post( sprintf(esc_html__('Font settings of the "%s" tag.', 'dixon'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = dixon_get_list_load_fonts(true);
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'dixon'),
						'100' => esc_html__('100 (Light)', 'dixon'), 
						'200' => esc_html__('200 (Light)', 'dixon'), 
						'300' => esc_html__('300 (Thin)',  'dixon'),
						'400' => esc_html__('400 (Normal)', 'dixon'),
						'500' => esc_html__('500 (Semibold)', 'dixon'),
						'600' => esc_html__('600 (Semibold)', 'dixon'),
						'700' => esc_html__('700 (Bold)', 'dixon'),
						'800' => esc_html__('800 (Black)', 'dixon'),
						'900' => esc_html__('900 (Black)', 'dixon')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'dixon'),
						'normal' => esc_html__('Normal', 'dixon'), 
						'italic' => esc_html__('Italic', 'dixon')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'dixon'),
						'none' => esc_html__('None', 'dixon'), 
						'underline' => esc_html__('Underline', 'dixon'),
						'overline' => esc_html__('Overline', 'dixon'),
						'line-through' => esc_html__('Line-through', 'dixon')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'dixon'),
						'none' => esc_html__('None', 'dixon'), 
						'uppercase' => esc_html__('Uppercase', 'dixon'),
						'lowercase' => esc_html__('Lowercase', 'dixon'),
						'capitalize' => esc_html__('Capitalize', 'dixon')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"refresh" => false,
					"std" => '$dixon_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		dixon_storage_merge_array('options', '', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			dixon_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'dixon'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'dixon') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'dixon')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}
	}
}




// -----------------------------------------------------------------
// -- Create and manage Theme Options
// -----------------------------------------------------------------

// Theme init priorities:
// 2 - create Theme Options
if (!function_exists('dixon_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'dixon_options_theme_setup2', 2 );
	function dixon_options_theme_setup2() {
		dixon_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('dixon_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'dixon_options_theme_setup5', 5 );
	function dixon_options_theme_setup5() {
		dixon_storage_set('options_reloaded', false);
		dixon_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('dixon_load_custom_options')) {
		add_action( 'wp_loaded', 'dixon_load_custom_options' );
		function dixon_load_custom_options() {
			if (!dixon_storage_get('options_reloaded')) {
				dixon_storage_set('options_reloaded', true);
				dixon_load_theme_options();
			}
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('dixon_load_theme_options') ) {
	function dixon_load_theme_options() {
		$options = dixon_storage_get('options');
		$reset = (int) get_theme_mod('reset_options', 0);
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$dixon_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				$value = $v['std'];
				if (!$reset) {
					if (isset($_GET[$k]))
						$value = $_GET[$k];
					else {
						$tmp = get_theme_mod($k, -987654321);
						if ($tmp != -987654321) $value = $tmp;
					}
				}
				dixon_storage_set_array2('options', $k, 'val', $value);
				if ($reset) remove_theme_mod($k);
			}
		}
		if ($reset) {
			// Unset reset flag
			set_theme_mod('reset_options', 0);
			// Regenerate CSS with default colors and fonts
			dixon_customizer_save_css();
		} else {
			do_action('dixon_action_load_options');
		}
	}
}

// Override options with stored page/post meta
if ( !function_exists('dixon_override_theme_options') ) {
	add_action( 'wp', 'dixon_override_theme_options', 1 );
	function dixon_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			dixon_storage_set('blog_archive', true);
			dixon_storage_set('blog_template', get_the_ID());
		}
		dixon_storage_set('blog_mode', dixon_detect_blog_mode());
		if (is_singular()) {
			dixon_storage_set('options_meta', get_post_meta(get_the_ID(), 'dixon_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('dixon_get_theme_option')) {
	function dixon_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!dixon_storage_isset('post_options_meta', $post_id))
				dixon_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'dixon_options', true));
			if (dixon_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = dixon_storage_get_array('post_options_meta', $post_id, $name);
				if (!dixon_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && dixon_storage_isset('options')) {
			if ( !dixon_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'dixon'), $name);
						if (function_exists('dco')) dco($s);
						else print_r($s);
						echo '</pre>';
						wp_die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = dixon_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = $_REQUEST[$name . '_' . $blog_mode];
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = $_REQUEST[$name];
				// Override option from current page settings (if exists)
				} else if (dixon_storage_isset('options_meta', $name) && !dixon_is_inherit(dixon_storage_get_array('options_meta', $name))) {
					$rez = dixon_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && dixon_storage_isset('options', $name . '_' . $blog_mode, 'val') && !dixon_is_inherit(dixon_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = dixon_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (dixon_storage_isset('options', $name, 'val')) {
					$rez = dixon_storage_get_array('options', $name, 'val');
				// Get ThemeREX Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('dixon_check_theme_option')) {
	function dixon_check_theme_option($name) {
		return dixon_storage_isset('options', $name);
	}
}

// Get dependencies list from the Theme Options
if ( !function_exists('dixon_get_theme_dependencies') ) {
	function dixon_get_theme_dependencies() {
		$options = dixon_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('dixon_get_theme_setting')) {
	function dixon_get_theme_setting($name) {
		return dixon_storage_isset('settings', $name) ? dixon_storage_get_array('settings', $name) : false;
	}
}


// Set theme setting
if ( !function_exists( 'dixon_set_theme_setting' ) ) {
	function dixon_set_theme_setting($option_name, $value) {
		if (dixon_storage_isset('settings', $option_name))
			dixon_storage_set_array('settings', $option_name, $value);
	}
}
?>