<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_post_id    = get_the_ID();
$dixon_post_date  = dixon_get_date();
$dixon_post_title = get_the_title();
$dixon_post_link  = get_permalink();
$dixon_post_author_id   = get_the_author_meta('ID');
$dixon_post_author_name = get_the_author_meta('display_name');
$dixon_post_author_url  = get_author_posts_url($dixon_post_author_id, '');

$dixon_args = get_query_var('dixon_args_widgets_posts');
$dixon_show_date = isset($dixon_args['show_date']) ? (int) $dixon_args['show_date'] : 1;
$dixon_show_image = isset($dixon_args['show_image']) ? (int) $dixon_args['show_image'] : 1;
$dixon_show_author = isset($dixon_args['show_author']) ? (int) $dixon_args['show_author'] : 1;
$dixon_show_counters = isset($dixon_args['show_counters']) ? (int) $dixon_args['show_counters'] : 1;
$dixon_show_categories = isset($dixon_args['show_categories']) ? (int) $dixon_args['show_categories'] : 1;

$dixon_output = dixon_storage_get('dixon_output_widgets_posts');

$dixon_post_counters_output = '';
if ( $dixon_show_counters ) {
	$dixon_post_counters_output = '<span class="post_info_item post_info_counters">'
								. dixon_get_post_counters('comments')
							. '</span>';
}


$dixon_output .= '<article class="post_item with_thumb">';

if ($dixon_show_image) {
	$dixon_post_thumb = get_the_post_thumbnail($dixon_post_id, dixon_get_thumb_size('tiny'), array(
		'alt' => get_the_title()
	));
	if ($dixon_post_thumb) $dixon_output .= '<div class="post_thumb">' . ($dixon_post_link ? '<a href="' . esc_url($dixon_post_link) . '">' : '') . ($dixon_post_thumb) . ($dixon_post_link ? '</a>' : '') . '</div>';
}

$dixon_output .= '<div class="post_content">'
			. ($dixon_show_categories 
					? '<div class="post_categories">'
						. dixon_get_post_categories()
						. $dixon_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($dixon_post_link ? '<a href="' . esc_url($dixon_post_link) . '">' : '') . ($dixon_post_title) . ($dixon_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('dixon_filter_get_post_info', 
								'<div class="post_info">'
									. ($dixon_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($dixon_post_link ? '<a href="' . esc_url($dixon_post_link) . '" class="post_info_date">' : '') 
											. esc_html($dixon_post_date) 
											. ($dixon_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($dixon_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'dixon') . ' ' 
											. ($dixon_post_link ? '<a href="' . esc_url($dixon_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($dixon_post_author_name) 
											. ($dixon_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$dixon_show_categories && $dixon_post_counters_output
										? $dixon_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
dixon_storage_set('dixon_output_widgets_posts', $dixon_output);
?>