<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

// Header sidebar
$dixon_header_name = dixon_get_theme_option('header_widgets');
$dixon_header_present = !dixon_is_off($dixon_header_name) && is_active_sidebar($dixon_header_name);
if ($dixon_header_present) { 
	dixon_storage_set('current_sidebar', 'header');
	$dixon_header_wide = dixon_get_theme_option('header_wide');
	ob_start();
	if ( !dynamic_sidebar($dixon_header_name) ) {
		// Put here html if user no set widgets in sidebar
	}
	$dixon_widgets_output = ob_get_contents();
	ob_end_clean();
	if (trim(strip_tags($dixon_widgets_output)) != '') {
		$dixon_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $dixon_widgets_output);
		$dixon_need_columns = strpos($dixon_widgets_output, 'columns_wrap')===false;
		if ($dixon_need_columns) {
			$dixon_columns = max(0, (int) dixon_get_theme_option('header_columns'));
			if ($dixon_columns == 0) $dixon_columns = min(6, max(1, substr_count($dixon_widgets_output, '<aside ')));
			if ($dixon_columns > 1)
				$dixon_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($dixon_columns).' widget ', $dixon_widgets_output);
			else
				$dixon_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($dixon_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$dixon_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($dixon_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'dixon_action_before_sidebar' );
				dixon_show_layout($dixon_widgets_output);
				do_action( 'dixon_action_after_sidebar' );
				if ($dixon_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$dixon_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>