<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

// Page (category, tag, archive, author) title

if ( dixon_need_page_title() ) {
	dixon_sc_layouts_showed('title', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_narrow">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title">
						<?php
						// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								dixon_show_post_meta(array(
									'date' => false,
									'categories' => false,
									'seo' => false,
									'share' => false,
									'edit' => false,
									'counters' => ''
									)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$dixon_blog_title = dixon_get_blog_title();
							$dixon_blog_title_text = $dixon_blog_title_class = $dixon_blog_title_link = $dixon_blog_title_link_text = '';
							if (is_array($dixon_blog_title)) {
								$dixon_blog_title_text = $dixon_blog_title['text'];
								$dixon_blog_title_class = !empty($dixon_blog_title['class']) ? ' '.$dixon_blog_title['class'] : '';
								$dixon_blog_title_link = !empty($dixon_blog_title['link']) ? $dixon_blog_title['link'] : '';
								$dixon_blog_title_link_text = !empty($dixon_blog_title['link_text']) ? $dixon_blog_title['link_text'] : '';
							} else
								$dixon_blog_title_text = $dixon_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($dixon_blog_title_class); ?>"><?php
								$dixon_top_icon = dixon_get_category_icon();
								if (!empty($dixon_top_icon)) {
									$dixon_attr = dixon_getimagesize($dixon_top_icon);
									?><img src="<?php echo esc_url($dixon_top_icon); ?>" alt="<?php echo esc_attr(basename($dixon_top_icon)); ?>" <?php if (!empty($dixon_attr[3])) dixon_show_layout($dixon_attr[3]);?>><?php
								}
								echo wp_kses_post($dixon_blog_title_text);
							?></h1>
							<?php
							if (!empty($dixon_blog_title_link) && !empty($dixon_blog_title_link_text)) {
								?><a href="<?php echo esc_url($dixon_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($dixon_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'dixon_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>