<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr(dixon_get_theme_option('menu_mobile_fullscreen') > 0 ? 'fullscreen' : 'narrow'); ?> 
scheme_sidemenu">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php

		// Logo
		set_query_var('dixon_logo_args', array('type' => 'inverse'));
		get_template_part( 'templates/header-logo' );
		set_query_var('dixon_logo_args', array());

		// Mobile menu
		$dixon_menu_mobile = dixon_get_nav_menu('menu_mobile');
		if (empty($dixon_menu_mobile)) {
			$dixon_menu_mobile = apply_filters('dixon_filter_get_mobile_menu', '');
			if (empty($dixon_menu_mobile)) $dixon_menu_mobile = dixon_get_nav_menu('menu_main');
			if (empty($dixon_menu_mobile)) $dixon_menu_mobile = dixon_get_nav_menu();
		}
		if (!empty($dixon_menu_mobile)) {
			if (!empty($dixon_menu_mobile))
				$dixon_menu_mobile = str_replace(
					array('menu_main', 'id="menu-', 'sc_layouts_menu_nav', 'sc_layouts_hide_on_mobile', 'hide_on_mobile'),
					array('menu_mobile', 'id="menu_mobile-', '', '', ''),
					$dixon_menu_mobile
					);
			if (strpos($dixon_menu_mobile, '<nav ')===false)
				$dixon_menu_mobile = sprintf('<nav class="menu_mobile_nav_area">%s</nav>', $dixon_menu_mobile);
			dixon_show_layout(apply_filters('dixon_filter_menu_mobile_layout', $dixon_menu_mobile));
		}

		// Search field
		do_action('dixon_action_search', 'normal', 'search_mobile', false);
		
		// Social icons
		dixon_show_layout(dixon_get_socials_links(), '<div class="socials_mobile">', '</div>');
		?>
	</div>
</div>
