<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_header_css = $dixon_header_image = '';
$dixon_header_video = dixon_get_header_video();
if (true || empty($dixon_header_video)) {
	$dixon_header_image = get_header_image();
	if (dixon_is_on(dixon_get_theme_option('header_image_override')) && apply_filters('dixon_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($dixon_cat_img = dixon_get_category_image()) != '')
				$dixon_header_image = $dixon_cat_img;
		} else if (is_singular() || dixon_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$dixon_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($dixon_header_image)) $dixon_header_image = $dixon_header_image[0];
			} else
				$dixon_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
					echo !empty($dixon_header_image) || !empty($dixon_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($dixon_header_video!='') echo ' with_bg_video';
					if ($dixon_header_image!='') echo ' '.esc_attr(dixon_add_inline_style('background-image: url('.esc_url($dixon_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (dixon_is_on(dixon_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(dixon_is_inherit(dixon_get_theme_option('header_scheme')) 
													? dixon_get_theme_option('color_scheme') 
													: dixon_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($dixon_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (dixon_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	get_template_part( 'templates/header-single' );

?></header>