<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0.10
 */

// Footer sidebar
$dixon_footer_name = dixon_get_theme_option('footer_widgets');
$dixon_footer_present = !dixon_is_off($dixon_footer_name) && is_active_sidebar($dixon_footer_name);
if ($dixon_footer_present) { 
	dixon_storage_set('current_sidebar', 'footer');
	$dixon_footer_wide = dixon_get_theme_option('footer_wide');
	ob_start();
	if ( !dynamic_sidebar($dixon_footer_name) ) {
		// Put here html if user no set widgets in sidebar
	}
	$dixon_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($dixon_out)) != '') {
		$dixon_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $dixon_out);
		$dixon_need_columns = true;
		if ($dixon_need_columns) {
			$dixon_columns = max(0, (int) dixon_get_theme_option('footer_columns'));
			if ($dixon_columns == 0) $dixon_columns = min(4, max(1, substr_count($dixon_out, '<aside ')));
			if ($dixon_columns > 1)
				$dixon_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($dixon_columns).' widget ', $dixon_out);
			else
				$dixon_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($dixon_footer_wide) ? ' footer_fullwidth' : ''; ?>">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$dixon_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($dixon_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'dixon_action_before_sidebar' );
				dixon_show_layout($dixon_out);
				do_action( 'dixon_action_after_sidebar' );
				if ($dixon_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$dixon_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>