<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0.10
 */

// Logo
if (dixon_is_on(dixon_get_theme_option('logo_in_footer'))) {
	$dixon_logo_image = '';
	if (dixon_get_retina_multiplier(2) > 1)
		$dixon_logo_image = dixon_get_theme_option( 'logo_footer_retina' );
	if (empty($dixon_logo_image)) 
		$dixon_logo_image = dixon_get_theme_option( 'logo_footer' );
	$dixon_logo_text   = get_bloginfo( 'name' );
	if (!empty($dixon_logo_image) || !empty($dixon_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($dixon_logo_image)) {
					$dixon_attr = dixon_getimagesize($dixon_logo_image);
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($dixon_logo_image).'" class="logo_footer_image" alt="'.esc_attr(basename($dixon_logo_image)).'"'.(!empty($dixon_attr[3]) ? sprintf(' %s', $dixon_attr[3]) : '').'></a>' ;
				} else if (!empty($dixon_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($dixon_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>