<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0.10
 */

// Copyright area
$dixon_footer_scheme =  dixon_is_inherit(dixon_get_theme_option('footer_scheme')) ? dixon_get_theme_option('color_scheme') : dixon_get_theme_option('footer_scheme');
$dixon_copyright_scheme = dixon_is_inherit(dixon_get_theme_option('copyright_scheme')) ? $dixon_footer_scheme : dixon_get_theme_option('copyright_scheme');
?> 
<div class="footer_copyright_wrap scheme_<?php echo esc_attr($dixon_copyright_scheme); ?>">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text"><?php
				// Replace {{...}} and [[...]] on the <i>...</i> and <b>...</b>
				$dixon_copyright = dixon_prepare_macros(dixon_get_theme_option('copyright'));
				if (!empty($dixon_copyright)) {
					// Replace {date_format} on the current date in the specified format
					if (preg_match("/(\\{[\\w\\d\\\\\\-\\:]*\\})/", $dixon_copyright, $dixon_matches)) {
						$dixon_copyright = str_replace($dixon_matches[1], date(str_replace(array('{', '}'), '', $dixon_matches[1])), $dixon_copyright);
					}
					// Display copyright
					echo wp_kses_data(nl2br($dixon_copyright));
				}
			?></div>
		</div>
	</div>
</div>
