<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_sidebar_position = dixon_get_theme_option('sidebar_position');
if (dixon_sidebar_present()) {
	ob_start();
	$dixon_sidebar_name = dixon_get_theme_option('sidebar_widgets');
	dixon_storage_set('current_sidebar', 'sidebar');
	if ( !dynamic_sidebar($dixon_sidebar_name) ) {
		// Put here html if user no set widgets in sidebar
	}
	$dixon_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($dixon_out)) != '') {
		?>
		<div class="sidebar <?php echo esc_attr($dixon_sidebar_position); ?> widget_area<?php if (!dixon_is_inherit(dixon_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(dixon_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'dixon_action_before_sidebar' );
				dixon_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $dixon_out));
				do_action( 'dixon_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>