<?php
/* WP GDPR Compliance support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_wp_gdpr_compliance_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_wp_gdpr_compliance_theme_setup9', 9 );
	function dixon_wp_gdpr_compliance_theme_setup9() {
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',			'dixon_wp_gdpr_compliance_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_wp_gdpr_compliance_tgmpa_required_plugins' ) ) {
	
	function dixon_wp_gdpr_compliance_tgmpa_required_plugins($list=array()) {
		if (in_array('wp-gdpr-compliance', dixon_storage_get('required_plugins'))) {
			// wp_gdpr_compliance plugin
			$list[] = array(
					'name' 		=> esc_html__('WP GDPR Compliance', 'dixon'),
					'slug' 		=> 'wp-gdpr-compliance',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if wp_gdpr_compliance installed and activated
if ( !function_exists( 'dixon_exists_wp_gdpr_compliance' ) ) {
	function dixon_exists_wp_gdpr_compliance() {
		return class_exists('WPGDPRC\WPGDPRC');
	}
}
?>