<?php
/* WPBakery Page Builder Extensions Bundle support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_vc_extensions_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_vc_extensions_theme_setup9', 9 );
	function dixon_vc_extensions_theme_setup9() {
		if (dixon_exists_visual_composer()) {
			add_action( 'wp_enqueue_scripts', 								'dixon_vc_extensions_frontend_scripts', 1100 );
			add_filter( 'dixon_filter_merge_styles',						'dixon_vc_extensions_merge_styles' );
		}
	
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',		'dixon_vc_extensions_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_vc_extensions_tgmpa_required_plugins' ) ) {
	
	function dixon_vc_extensions_tgmpa_required_plugins($list=array()) {
		if (in_array('vc-extensions-bundle', dixon_storage_get('required_plugins'))) {
			$path = dixon_get_file_dir('plugins/vc-extensions-bundle/vc-extensions-bundle.zip');
			$list[] = array(
					'name' 		=> esc_html__('WPBakery Page Builder Extensions Bundle', 'dixon'),
					'slug' 		=> 'vc-extensions-bundle',
					'source'	=> !empty($path) ? $path : 'upload://vc-extensions-bundle.zip',
					'version'  => '3.6.1',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if VC Extensions installed and activated
if ( !function_exists( 'dixon_exists_vc_extensions' ) ) {
	function dixon_exists_vc_extensions() {
		return class_exists('Vc_Manager') && class_exists('VC_Extensions_CQBundle');
	}
}
	
// Enqueue VC custom styles
if ( !function_exists( 'dixon_vc_extensions_frontend_scripts' ) ) {
	
	function dixon_vc_extensions_frontend_scripts() {
		if (dixon_is_on(dixon_get_theme_option('debug_mode')) && dixon_get_file_dir('plugins/vc-extensions-bundle/vc-extensions-bundle.css')!='')
			wp_enqueue_style( 'dixon-vc-extensions-bundle',  dixon_get_file_url('plugins/vc-extensions-bundle/vc-extensions-bundle.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'dixon_vc_extensions_merge_styles' ) ) {
	
	function dixon_vc_extensions_merge_styles($list) {
		$list[] = 'plugins/vc-extensions-bundle/vc-extensions-bundle.css';
		return $list;
	}
}
?>