<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_trx_updater_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_trx_updater_theme_setup9', 9 );
	function dixon_trx_updater_theme_setup9() {
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',	'dixon_trx_updater_tgmpa_required_plugins' );
		}
	}
}

// Check if trx_updater installed and activated
if ( !function_exists( 'dixon_exists_trx_updater' ) ) {
	function dixon_exists_trx_updater() {
		return function_exists('TRX_UPDATER_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_trx_updater_tgmpa_required_plugins' ) ) {
	
	function dixon_trx_updater_tgmpa_required_plugins($list=array()) {
		if (in_array('trx_updater', dixon_storage_get('required_plugins'))) {
			$path = dixon_get_file_dir('plugins/trx_updater/trx_updater.zip');
			$list[] = array(
					'name' 		=> esc_html__('ThemeREX Updater', 'dixon'),
					'slug' 		=> 'trx_updater',
					'source'	=> !empty($path) ? $path : 'upload://trx_updater.zip',
					'version'  => '1.7.0',
					'required' 	=> false
			);
		}
		return $list;
	}
}
?>