<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_revslider_theme_setup9', 9 );
	function dixon_revslider_theme_setup9() {
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',	'dixon_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'dixon_exists_revslider' ) ) {
	function dixon_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_revslider_tgmpa_required_plugins' ) ) {
	
	function dixon_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', dixon_storage_get('required_plugins'))) {
			$path = dixon_get_file_dir('plugins/revslider/revslider.zip');
			$list[] = array(
					'name' 		=> esc_html__('Revolution Slider', 'dixon'),
					'slug' 		=> 'revslider',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'version'  => '6.4.8',
					'required' 	=> false
			);
		}
		return $list;
	}
}

// Allow loading RevSlider scripts and styles
// if it present in the content of the current page
if (!function_exists('dixon_revslider_check_revslider_in_content')) {
	add_filter( 'revslider_include_libraries', 'dixon_revslider_check_revslider_in_content' );
	function dixon_revslider_check_revslider_in_content( $load ) {
		if ( ! $load && function_exists( 'trx_addons_check_revslider_in_content' ) && dixon_is_layouts_available() ) {
			// Check slider in the page header
			if ( apply_filters( 'dixon_filter_check_revslider_in_header', true ) ) {
				$header_type = dixon_get_theme_option( 'header_type' );
				if ( 'custom' == $header_type ) {
					$header_id = dixon_get_custom_header_id();
					if ( $header_id > 0 ) {
						$load = trx_addons_check_revslider_in_content( false, $header_id );
					}
				}
			}
			// Check slider in the page footer
			if ( apply_filters( 'dixon_filter_check_revslider_in_footer', false ) ) {
				$footer_type = dixon_get_theme_option( 'footer_type' );
				if ( 'custom' == $footer_type ) {
					$footer_id = dixon_get_custom_footer_id();
					if ( $footer_id > 0 ) {
						$load = trx_addons_check_revslider_in_content( false, $footer_id );
					}
				}
			}
		}
		return $load;
	}
}

?>