<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_mailchimp_theme_setup9', 9 );
	function dixon_mailchimp_theme_setup9() {
		if (dixon_exists_mailchimp()) {
			add_action( 'wp_enqueue_scripts',							'dixon_mailchimp_frontend_scripts', 1100 );
			add_filter( 'dixon_filter_merge_styles',					'dixon_mailchimp_merge_styles');
			add_filter( 'dixon_filter_get_css',						'dixon_mailchimp_get_css', 10, 4);
		}
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',		'dixon_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'dixon_exists_mailchimp' ) ) {
	function dixon_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_mailchimp_tgmpa_required_plugins' ) ) {
	
	function dixon_mailchimp_tgmpa_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', dixon_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'dixon'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue custom styles
if ( !function_exists( 'dixon_mailchimp_frontend_scripts' ) ) {
	
	function dixon_mailchimp_frontend_scripts() {
		if (dixon_exists_mailchimp()) {
			if (dixon_is_on(dixon_get_theme_option('debug_mode')) && dixon_get_file_dir('plugins/mailchimp-for-wp/mailchimp-for-wp.css')!='')
				wp_enqueue_style( 'dixon-mailchimp-for-wp',  dixon_get_file_url('plugins/mailchimp-for-wp/mailchimp-for-wp.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'dixon_mailchimp_merge_styles' ) ) {
	
	function dixon_mailchimp_merge_styles($list) {
		$list[] = 'plugins/mailchimp-for-wp/mailchimp-for-wp.css';
		return $list;
	}
}

// Add css styles into global CSS stylesheet
if (!function_exists('dixon_mailchimp_get_css')) {
	
	function dixon_mailchimp_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		
			
			$rad = dixon_get_border_radius();
			$css['fonts'] .= <<<CSS

.mc4wp-form .mc4wp-form-fields input[type="email"],
.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$rad};
	   -moz-border-radius: {$rad};
	    -ms-border-radius: {$rad};
			border-radius: {$rad};
}

CSS;
		}

		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.mc4wp-form input[type="email"] {
	background-color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
	color: {$colors['bg_color']};
}
.mc4wp-form input[type="submit"] {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}
.mc4wp-form input[type="submit"]:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['alter_link_blend']};
}

CSS;
		}

		return $css;
	}
}
?>