<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_essential_grid_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_essential_grid_theme_setup9', 9 );
	function dixon_essential_grid_theme_setup9() {
		if (dixon_exists_essential_grid()) {
			add_action( 'wp_enqueue_scripts', 							'dixon_essential_grid_frontend_scripts', 1100 );
			add_filter( 'dixon_filter_merge_styles',					'dixon_essential_grid_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',		'dixon_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'dixon_exists_essential_grid' ) ) {
	function dixon_exists_essential_grid() {
		return defined('EG_PLUGIN_PATH');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_essential_grid_tgmpa_required_plugins' ) ) {
	
	function dixon_essential_grid_tgmpa_required_plugins($list=array()) {
		if (in_array('essential-grid', dixon_storage_get('required_plugins'))) {
			$path = dixon_get_file_dir('plugins/essential-grid/essential-grid.zip');
			$list[] = array(
						'name' 		=> esc_html__('Essential Grid', 'dixon'),
						'slug' 		=> 'essential-grid',
						'source'	=> !empty($path) ? $path : 'upload://essential-grid.zip',
						'version'  => '3.0.11',
						'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'dixon_essential_grid_frontend_scripts' ) ) {
	
	function dixon_essential_grid_frontend_scripts() {
		if (dixon_is_on(dixon_get_theme_option('debug_mode')) && dixon_get_file_dir('plugins/essential-grid/essential-grid.css')!='')
			wp_enqueue_style( 'dixon-essential-grid',  dixon_get_file_url('plugins/essential-grid/essential-grid.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'dixon_essential_grid_merge_styles' ) ) {
	
	function dixon_essential_grid_merge_styles($list) {
		$list[] = 'plugins/essential-grid/essential-grid.css';
		return $list;
	}
}
?>