<?php
/* Content Timeline support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_content_timeline_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_content_timeline_theme_setup9', 9 );
	function dixon_content_timeline_theme_setup9() {
		
		if (dixon_exists_content_timeline()) {
			add_action( 'wp_enqueue_scripts',								'dixon_content_timeline_frontend_scripts', 1100 );
			add_filter( 'dixon_filter_merge_styles',						'dixon_content_timeline_merge_styles' );
			add_filter( 'dixon_filter_get_css',							'dixon_content_timeline_get_css', 10, 4 );
		}
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',			'dixon_content_timeline_tgmpa_required_plugins' );
		}

	}
}

// Check if plugin is installed and activated
if ( !function_exists( 'dixon_exists_content_timeline' ) ) {
	function dixon_exists_content_timeline() {
		return class_exists( 'ContentTimelineAdmin' );
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'dixon_content_timeline_frontend_scripts' ) ) {
	
	function dixon_content_timeline_frontend_scripts() {
		if ( dixon_is_on(dixon_get_theme_option('debug_mode')) && dixon_get_file_dir('plugins/content_timeline/content_timeline.css')!='')
			wp_enqueue_style( 'dixon-content-timeline',  dixon_get_file_url('plugins/content_timeline/content_timeline.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'dixon_content_timeline_merge_styles' ) ) {
	
	function dixon_content_timeline_merge_styles($list) {
		$list[] = 'plugins/content_timeline/content_timeline.css';
		return $list;
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_content_timeline_tgmpa_required_plugins' ) ) {
	
	function dixon_content_timeline_tgmpa_required_plugins($list=array()) {
		if (in_array('content_timeline', dixon_storage_get('required_plugins'))) {
			$path = dixon_get_file_dir('plugins/content_timeline/content_timeline.zip');
			$list[] = array(
						'name' 		=> esc_html__('Content Timeline', 'dixon'),
						'slug' 		=> 'content_timeline',
						'source'	=> !empty($path) ? $path : 'upload://content_timeline.zip',
						'required' 	=> false
				);
		}
		return $list;
	}
}


// Add plugin's specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'dixon_content_timeline_get_css' ) ) {
	
	function dixon_content_timeline_get_css($css, $colors, $fonts, $scheme='') {
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
			
.timeline.my_style_style_4 .t_line_month,
.timeline.my_style_style_4 a.t_line_node,
.timeline.my_style_style_4 .item .my_timeline_content .read_more {
	{$fonts['p_font-family']}
}

CSS;
		}

		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Timeline */
.timeline.my_style_style_4 .timeline_line {
	background-color: {$colors['text_dark']};
	color: {$colors['text']};
}
.timeline.my_style_style_4 .t_line_month {
	color: {$colors['bg_color']};
}
.timeline.my_style_style_4 .t_line_wrapper:after {
	border-bottom-color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node {
	color: {$colors['text']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node.active {
	color: {$colors['bg_color']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node:after {
	background: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .t_line_node.active:after {
	border-color: {$colors['text_link']} !important;
	background: {$colors['text_dark']} !important;
}
#tl1.timeline.my_style_style_4 #t_line_left, 
#tl1.timeline.my_style_style_4 #t_line_right {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 #t_line_left:hover, 
#tl1.timeline.my_style_style_4 #t_line_right:hover {
	color: {$colors['bg_color']} !important;
}
.timeline.my_style_style_4 .t_node_desc {
	color: {$colors['bg_color']};
}
.timeline.my_style_style_4 .t_node_desc span {
	background: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .t_node_desc span:after {
	border-top-color: {$colors['text_link']};
}

/* Items */
.timeline.my_style_style_4 .item {
	background: {$colors['bg_color']} !important;
}
.timeline.my_style_style_4 .timeline_items_wrapper .item h2 {
	color: {$colors['text_dark']} !important;
}
.timeline.my_style_style_4 .my_post_date {
	color: {$colors['text_light']} !important;
}
.timeline.my_style_style_4 .my_timeline_content span {
	color: {$colors['text']} !important;
}
#tl1.timeline.my_style_style_4 .my_timeline_content .read_more {
	color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .my_timeline_content .read_more:hover {
	color: {$colors['text_dark']} !important;
}
#tl1.timeline.my_style_style_4 .item_node_hover:before {
	background-color: {$colors['text_link']} !important;
}
#tl1.timeline.my_style_style_4 .item_node_hover:after {
	border-top-color: {$colors['text_link']} !important;
}

CSS;
		}
		
		return $css;
	}
}
?>