<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('dixon_booked_theme_setup9')) {
	add_action( 'after_setup_theme', 'dixon_booked_theme_setup9', 9 );
	function dixon_booked_theme_setup9() {
		if (dixon_exists_booked()) {
			add_action( 'wp_enqueue_scripts', 							'dixon_booked_frontend_scripts', 1100 );
			add_filter( 'dixon_filter_merge_styles',					'dixon_booked_merge_styles' );
			add_filter( 'dixon_filter_get_css',						'dixon_booked_get_css', 10, 4);
		}
		if (is_admin()) {
			add_filter( 'dixon_filter_tgmpa_required_plugins',		'dixon_booked_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'dixon_exists_booked' ) ) {
	function dixon_exists_booked() {
		return class_exists('booked_plugin');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'dixon_booked_tgmpa_required_plugins' ) ) {
	
	function dixon_booked_tgmpa_required_plugins($list=array()) {
		if (in_array('booked', dixon_storage_get('required_plugins'))) {
			$path = dixon_get_file_dir('plugins/booked/booked.zip');
			$list[] = array(
					'name' 		=> esc_html__('Booked Appointments', 'dixon'),
					'slug' 		=> 'booked',
					'source' 	=> !empty($path) ? $path : 'upload://booked.zip',
					'version'  => '2.3.5',
					'required' 	=> false
			);
		}
		return $list;
	}
}
	
// Enqueue plugin's custom styles
if ( !function_exists( 'dixon_booked_frontend_scripts' ) ) {
	
	function dixon_booked_frontend_scripts() {
		if (dixon_is_on(dixon_get_theme_option('debug_mode')) && dixon_get_file_dir('plugins/booked/booked.css')!='')
			wp_enqueue_style( 'dixon-booked',  dixon_get_file_url('plugins/booked/booked.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'dixon_booked_merge_styles' ) ) {
	
	function dixon_booked_merge_styles($list) {
		$list[] = 'plugins/booked/booked.css';
		return $list;
	}
}


// Add plugin-specific rules into custom CSS
//------------------------------------------------------------------------

// Add css styles into global CSS stylesheet
if (!function_exists('dixon_booked_get_css')) {
	
	function dixon_booked_get_css($css, $colors, $fonts, $scheme='') {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body table.booked-calendar button,
body .booked-modal input[type="submit"],
body .booked-modal button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

/* Calendar */
.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-title {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text']};
}

/* Form fields */
#booked-page-form {
	color: {$colors['text']};
	border-color: {$colors['bd_color']};
}
#booked-page-form input[type="email"],
#booked-page-form input[type="text"],
#booked-page-form input[type="password"],
#booked-page-form textarea,
.booked-upload-wrap,
.booked-upload-wrap input {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_color']};
	background-color: {$colors['input_bg_color']};
}
#booked-page-form input[type="email"]:focus,
#booked-page-form input[type="text"]:focus,
#booked-page-form input[type="password"]:focus,
#booked-page-form textarea:focus,
.booked-upload-wrap:hover,
.booked-upload-wrap input:focus {
	color: {$colors['input_dark']};
	border-color: {$colors['input_bd_hover']};
	background-color: {$colors['input_bg_hover']};
}

#booked-profile-page .booked-profile-header {
	background-color: {$colors['bg_color']} !important;
	border-color: transparent !important;
	color: {$colors['text']};
}
#booked-profile-page .booked-user h3 {
	color: {$colors['text_dark']};
}
#booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_link']};
}

table.booked-calendar tr.days th,
#booked-profile-page .booked-tabs {
	border-color: {$colors['bg_color']} !important;
	background-color: {$colors['accent2']} !important;
}

table.booked-calendar tr.days,
.booked-calendarSwitcher.calendar,
.booked-calendarSwitcher.calendar select,
#booked-profile-page .booked-tabs {
	background-color: {$colors['alter_bg_color']} !important;
}
#booked-profile-page .booked-tabs li a {
	background-color: {$colors['alter_bg_hover']};
	color: {$colors['alter_dark']};
}
#booked-profile-page input.button-primary[type="submit"]:hover,
.booked-list-view button.button:hover,
.booked-list-view input.button-primary[type="submit"]:hover,
table.booked-calendar input.button-primary[type="submit"]:hover,
.booked-modal input.button-primary[type="submit"]:hover,
table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover,
#booked-profile-page .booked-tabs li.active a,
#booked-profile-page .booked-tabs li.active a:hover,
#booked-profile-page .booked-tabs li a:hover,
#booked-profile-page .appt-block .google-cal-button > a:hover {
	background-color: {$colors['alter_dark']} !important;
	color: {$colors['bg_color']} !important;
}
#booked-profile-page .booked-tab-content {
	background-color: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}

table.booked-calendar thead tr:not(.days) th{
	color: {$colors['text_dark']} !important;
}

table.booked-calendar thead tr.days th:first-child{
	border-left-color: {$colors['accent2']} !important;
}
table.booked-calendar thead tr.days th:last-child{
	border-right-color: {$colors['accent2']} !important;
}


body table.booked-calendar thead th .page-right > *, 
body table.booked-calendar thead th .page-left > * {
	color: {$colors['text_dark']} !important;
}

body table.booked-calendar thead th .page-right:hover > *, 
body table.booked-calendar thead th .page-left:hover > * {
	color: {$colors['text_hover']} !important;
}

body table.booked-calendar td.today .date span {
	color: {$colors['text_dark']} !important;
	border-color: {$colors['text_link']} !important;

}

body table.booked-calendar td.today:hover .date span {
	color: {$colors['inverse_dark']} !important;
	background-color: {$colors['text_link']} !important;
}

body #booked-profile-page input[type=submit].button-primary, 
body table.booked-calendar input[type=submit].button-primary, 
body .booked-list-view button.button, 
body .booked-list-view input[type=submit].button-primary, 
body .booked-list-view button.button, 
body .booked-list-view input[type=submit].button-primary, 
body .booked-modal input[type=submit].button-primary, 
body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button, 
body #booked-profile-page .booked-profile-appt-list .appt-block.approved .status-block, 
body #booked-profile-page .appt-block .google-cal-button > a, 
body .booked-modal p.booked-title-bar, 
body table.booked-calendar td:hover .date span, 
body .booked-list-view a.booked_list_date_picker_trigger.booked-dp-active, 
body .booked-list-view a.booked_list_date_picker_trigger.booked-dp-active:hover, 
.booked-ms-modal .booked-book-appt {
	background: {$colors['text_link']} !important;
	border-color: transparent;

}

body table.booked-calendar tr.week td.active .date .number {
	color: {$colors['inverse_dark']} !important;
	background-color: {$colors['text_link']} !important;	
}

body #booked-profile-page input[type=submit].button-primary:hover, 
body table.booked-calendar input[type=submit].button-primary:hover, 
body .booked-list-view button.button:hover, 
body .booked-list-view input[type=submit].button-primary:hover, 
body .booked-modal input[type=submit].button-primary:hover, 
body table.booked-calendar th, 
body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover, 
body #booked-profile-page .booked-profile-header, 
body #booked-profile-page .appt-block .google-cal-button > a:hover {
	background-color: {$colors['text_hover']} !important;	
	border-color: {$colors['text_hover']} !important;	
}

body .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button[disabled], 
body .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button[disabled]:hover {
	color: {$colors['inverse_dark']} !important;	
}

.bm-window .close i{
	color: {$colors['inverse_dark']} !important;	
}
.bm-window .close i:hover{
	color: {$colors['text_dark']} !important;	
}

CSS;
		}

		return $css;
	}
}
?>