<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

dixon_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', dixon_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded', dixon_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
wp_enqueue_script( 'masonry', dixon_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
wp_enqueue_script( 'dixon-gallery-script', dixon_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$dixon_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$dixon_sticky_out = is_array($dixon_stickies) && count($dixon_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$dixon_cat = dixon_get_theme_option('parent_cat');
	$dixon_post_type = dixon_get_theme_option('post_type');
	$dixon_taxonomy = dixon_get_post_type_taxonomy($dixon_post_type);
	$dixon_show_filters = dixon_get_theme_option('show_filters');
	$dixon_tabs = array();
	if (!dixon_is_off($dixon_show_filters)) {
		$dixon_args = array(
			'type'			=> $dixon_post_type,
			'child_of'		=> $dixon_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $dixon_taxonomy,
			'pad_counts'	=> false
		);
		$dixon_portfolio_list = get_terms($dixon_args);
		if (is_array($dixon_portfolio_list) && count($dixon_portfolio_list) > 0) {
			$dixon_tabs[$dixon_cat] = esc_html__('All', 'dixon');
			foreach ($dixon_portfolio_list as $dixon_term) {
				if (isset($dixon_term->term_id)) $dixon_tabs[$dixon_term->term_id] = $dixon_term->name;
			}
		}
	}
	if (count($dixon_tabs) > 0) {
		$dixon_portfolio_filters_ajax = true;
		$dixon_portfolio_filters_active = $dixon_cat;
		$dixon_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters dixon_tabs dixon_tabs_ajax">
			<ul class="portfolio_titles dixon_tabs_titles">
				<?php
				foreach ($dixon_tabs as $dixon_id=>$dixon_title) {
					?><li><a href="<?php echo esc_url(dixon_get_hash_link(sprintf('#%s_%s_content', $dixon_portfolio_filters_id, $dixon_id))); ?>" data-tab="<?php echo esc_attr($dixon_id); ?>"><?php echo esc_html($dixon_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$dixon_ppp = dixon_get_theme_option('posts_per_page');
			if (dixon_is_inherit($dixon_ppp)) $dixon_ppp = '';
			foreach ($dixon_tabs as $dixon_id=>$dixon_title) {
				$dixon_portfolio_need_content = $dixon_id==$dixon_portfolio_filters_active || !$dixon_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $dixon_portfolio_filters_id, $dixon_id)); ?>"
					class="portfolio_content dixon_tabs_content"
					data-blog-template="<?php echo esc_attr(dixon_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(dixon_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($dixon_ppp); ?>"
					data-post-type="<?php echo esc_attr($dixon_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($dixon_taxonomy); ?>"
					data-cat="<?php echo esc_attr($dixon_id); ?>"
					data-parent-cat="<?php echo esc_attr($dixon_cat); ?>"
					data-need-content="<?php echo (false===$dixon_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($dixon_portfolio_need_content) 
						dixon_show_portfolio_posts(array(
							'cat' => $dixon_id,
							'parent_cat' => $dixon_cat,
							'taxonomy' => $dixon_taxonomy,
							'post_type' => $dixon_post_type,
							'page' => 1,
							'sticky' => $dixon_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		dixon_show_portfolio_posts(array(
			'cat' => $dixon_cat,
			'parent_cat' => $dixon_cat,
			'taxonomy' => $dixon_taxonomy,
			'post_type' => $dixon_post_type,
			'page' => 1,
			'sticky' => $dixon_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>