<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('dixon_storage_get')) {
	function dixon_storage_get($var_name, $default='') {
		global $DIXON_STORAGE;
		return isset($DIXON_STORAGE[$var_name]) ? $DIXON_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('dixon_storage_set')) {
	function dixon_storage_set($var_name, $value) {
		global $DIXON_STORAGE;
		$DIXON_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('dixon_storage_empty')) {
	function dixon_storage_empty($var_name, $key='', $key2='') {
		global $DIXON_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($DIXON_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($DIXON_STORAGE[$var_name][$key]);
		else
			return empty($DIXON_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('dixon_storage_isset')) {
	function dixon_storage_isset($var_name, $key='', $key2='') {
		global $DIXON_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($DIXON_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($DIXON_STORAGE[$var_name][$key]);
		else
			return isset($DIXON_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('dixon_storage_inc')) {
	function dixon_storage_inc($var_name, $value=1) {
		global $DIXON_STORAGE;
		if (empty($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = 0;
		$DIXON_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('dixon_storage_concat')) {
	function dixon_storage_concat($var_name, $value) {
		global $DIXON_STORAGE;
		if (empty($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = '';
		$DIXON_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('dixon_storage_get_array')) {
	function dixon_storage_get_array($var_name, $key, $key2='', $default='') {
		global $DIXON_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($DIXON_STORAGE[$var_name][$key]) ? $DIXON_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($DIXON_STORAGE[$var_name][$key][$key2]) ? $DIXON_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('dixon_storage_set_array')) {
	function dixon_storage_set_array($var_name, $key, $value) {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if ($key==='')
			$DIXON_STORAGE[$var_name][] = $value;
		else
			$DIXON_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('dixon_storage_set_array2')) {
	function dixon_storage_set_array2($var_name, $key, $key2, $value) {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if (!isset($DIXON_STORAGE[$var_name][$key])) $DIXON_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$DIXON_STORAGE[$var_name][$key][] = $value;
		else
			$DIXON_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('dixon_storage_merge_array')) {
	function dixon_storage_merge_array($var_name, $key, $value) {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if ($key==='')
			$DIXON_STORAGE[$var_name] = array_merge($DIXON_STORAGE[$var_name], $value);
		else
			$DIXON_STORAGE[$var_name][$key] = array_merge($DIXON_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('dixon_storage_set_array_after')) {
	function dixon_storage_set_array_after($var_name, $after, $key, $value='') {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if (is_array($key))
			dixon_array_insert_after($DIXON_STORAGE[$var_name], $after, $key);
		else
			dixon_array_insert_after($DIXON_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('dixon_storage_set_array_before')) {
	function dixon_storage_set_array_before($var_name, $before, $key, $value='') {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if (is_array($key))
			dixon_array_insert_before($DIXON_STORAGE[$var_name], $before, $key);
		else
			dixon_array_insert_before($DIXON_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('dixon_storage_push_array')) {
	function dixon_storage_push_array($var_name, $key, $value) {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($DIXON_STORAGE[$var_name], $value);
		else {
			if (!isset($DIXON_STORAGE[$var_name][$key])) $DIXON_STORAGE[$var_name][$key] = array();
			array_push($DIXON_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('dixon_storage_pop_array')) {
	function dixon_storage_pop_array($var_name, $key='', $defa='') {
		global $DIXON_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($DIXON_STORAGE[$var_name]) && is_array($DIXON_STORAGE[$var_name]) && count($DIXON_STORAGE[$var_name]) > 0) 
				$rez = array_pop($DIXON_STORAGE[$var_name]);
		} else {
			if (isset($DIXON_STORAGE[$var_name][$key]) && is_array($DIXON_STORAGE[$var_name][$key]) && count($DIXON_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($DIXON_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('dixon_storage_inc_array')) {
	function dixon_storage_inc_array($var_name, $key, $value=1) {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if (empty($DIXON_STORAGE[$var_name][$key])) $DIXON_STORAGE[$var_name][$key] = 0;
		$DIXON_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('dixon_storage_concat_array')) {
	function dixon_storage_concat_array($var_name, $key, $value) {
		global $DIXON_STORAGE;
		if (!isset($DIXON_STORAGE[$var_name])) $DIXON_STORAGE[$var_name] = array();
		if (empty($DIXON_STORAGE[$var_name][$key])) $DIXON_STORAGE[$var_name][$key] = '';
		$DIXON_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('dixon_storage_call_obj_method')) {
	function dixon_storage_call_obj_method($var_name, $method, $param=null) {
		global $DIXON_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($DIXON_STORAGE[$var_name]) ? $DIXON_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($DIXON_STORAGE[$var_name]) ? $DIXON_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('dixon_storage_get_obj_property')) {
	function dixon_storage_get_obj_property($var_name, $prop, $default='') {
		global $DIXON_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($DIXON_STORAGE[$var_name]->$prop) ? $DIXON_STORAGE[$var_name]->$prop : $default;
	}
}
?>