<?php
/**
 * The default template to display the content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post_item_single post_type_'.esc_attr(get_post_type()) 
												. ' post_format_'.esc_attr(str_replace('post-format-', '', get_post_format())) 
												. ' itemscope'
												); ?>
		itemscope itemtype="<?php echo esc_attr( dixon_get_protocol( true ) ); ?>//schema.org/<?php echo esc_attr(is_single() ? 'BlogPosting' : 'Article'); ?>">
	<?php
	// Structured data snippets
	if (dixon_is_on(dixon_get_theme_option('seo_snippets'))) {
		?>
		<div class="structured_data_snippets">
			<meta itemprop="headline" content="<?php the_title_attribute(); ?>">
			<meta itemprop="datePublished" content="<?php echo esc_attr(get_the_date('Y-m-d')); ?>">
			<meta itemprop="dateModified" content="<?php echo esc_attr(get_the_modified_date('Y-m-d')); ?>">
			<meta itemscope itemprop="mainEntityOfPage" itemType="<?php echo esc_attr( dixon_get_protocol( true ) ); ?>//schema.org/WebPage" itemid="<?php echo esc_url(get_the_permalink()); ?>" content="<?php the_title_attribute(); ?>"/>	
			<div itemprop="publisher" itemscope itemtype="<?php echo esc_attr( dixon_get_protocol( true ) ); ?>//schema.org/Organization">
				<div itemprop="logo" itemscope itemtype="<?php echo esc_attr( dixon_get_protocol( true ) ); ?>//schema.org/ImageObject">
					<?php 
					$dixon_logo_image = dixon_get_retina_multiplier(2) > 1 
										? dixon_get_theme_option( 'logo_retina' )
										: dixon_get_theme_option( 'logo' );
					if (!empty($dixon_logo_image)) {
						$dixon_attr = dixon_getimagesize($dixon_logo_image);
						?>
						<img itemprop="url" src="<?php echo esc_url($dixon_logo_image); ?>">
						<meta itemprop="width" content="<?php echo esc_attr($dixon_attr[0]); ?>">
						<meta itemprop="height" content="<?php echo esc_attr($dixon_attr[1]); ?>">
						<?php
					}
					?>
				</div>
				<meta itemprop="name" content="<?php echo esc_attr(get_bloginfo( 'name' )); ?>">
				<meta itemprop="telephone" content="">
				<meta itemprop="address" content="">
			</div>
		</div>
		<?php
	}

	// Post meta on the single post
	if ( is_single() )  {
		// Title and post meta
		if (get_the_title() != '') {
			?>
			<div class="post_header entry-header">
				<?php
				do_action('dixon_action_before_post_title');

				// Post title
				the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

				?>
			</div><!-- .post_header --><?php
		}
	}
	
	// Featured image
	if ( !dixon_sc_layouts_showed('featured'))
		dixon_show_post_featured();

	// Title and post meta
	if ( !dixon_sc_layouts_showed('title') && !in_array(get_post_format(), array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( '<h3 class="post_title entry-title"'.(dixon_is_on(dixon_get_theme_option('seo_snippets')) ? ' itemprop="headline"' : '').'>', '</h3>' );
			// Post meta
			dixon_show_post_meta(array(
				'seo' => dixon_is_on(dixon_get_theme_option('seo_snippets')),
				'share' => false,
				'counters' => 'comments,views,likes'
				)
			);
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post meta on the single post
	if ( is_single() )  {
		// Title and post meta
		?>
		<div class="post_header entry-header">
			<?php
			do_action('dixon_action_before_post_meta'); 

			// Post meta
			dixon_show_post_meta(array(
				'author' => true,
				'categories' => false,
				'date' => true,
				'edit' => false,
				'seo' => false,
				'share' => false,
				'counters' => 'comments'	//comments,likes,views - comma separated in any combination
				)
			);
			?>
		</div><!-- .post_header --><?php
	}

	// Post content
	?>
	<div class="post_content entry-content" itemprop="articleBody">
		<?php
			the_content( );

			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'dixon' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'dixon' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

			// Taxonomies and share
			if ( is_single() && !is_attachment() ) {
				?>
				<div class="post_meta post_meta_single"><?php
					
					// Post taxonomies
					the_tags( '<span class="post_meta_item post_tags"><span class="post_meta_label">'.esc_html__('Tags:', 'dixon').'</span> ', ', ', '</span>' );

					// Share
					dixon_show_share_links(array(
							'type' => 'block',
							'caption' => '',
							'before' => '<span class="post_meta_item post_share">',
							'after' => '</span>'
						));
					?>
				</div>
				<?php
			}
		?>
	</div><!-- .entry-content -->

	<?php
		// Author bio.
		if ( is_single() && !is_attachment() && get_the_author_meta( 'description' ) ) {	
			get_template_part( 'templates/author-bio' );
		}
	?>
</article>
