<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$dixon_post_format = get_post_format();
$dixon_post_format = empty($dixon_post_format) ? 'standard' : str_replace('post-format-', '', $dixon_post_format);
$dixon_animation = dixon_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($dixon_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($dixon_post_format) ); ?>
	<?php echo (!dixon_is_off($dixon_animation) ? ' data-animation="'.esc_attr(dixon_get_animation_classes($dixon_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	dixon_show_post_featured(array(
		'thumb_size' => dixon_get_thumb_size($dixon_columns==1 ? 'big' : ($dixon_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($dixon_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			dixon_show_post_meta(array(
				'author' => true,
				'categories' => false,
				'date' => true,
				'edit' => false,
				'seo' => false,
				'share' => false,
				'counters' => '',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>