<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_blog_style = explode('_', dixon_get_theme_option('blog_style'));
$dixon_columns = empty($dixon_blog_style[1]) ? 2 : max(2, $dixon_blog_style[1]);
$dixon_post_format = get_post_format();
$dixon_post_format = empty($dixon_post_format) ? 'standard' : str_replace('post-format-', '', $dixon_post_format);
$dixon_animation = dixon_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($dixon_columns).' post_format_'.esc_attr($dixon_post_format) ); ?>
	<?php echo (!dixon_is_off($dixon_animation) ? ' data-animation="'.esc_attr(dixon_get_animation_classes($dixon_animation)).'"' : ''); ?>
	>

	<?php
	$dixon_image_hover = dixon_get_theme_option('image_hover');
	// Featured image
	dixon_show_post_featured(array(
		'thumb_size' => dixon_get_thumb_size(strpos(dixon_get_theme_option('body_style'), 'full')!==false || $dixon_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $dixon_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $dixon_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>