<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_blog_style = explode('_', dixon_get_theme_option('blog_style'));
$dixon_columns = empty($dixon_blog_style[1]) ? 2 : max(2, $dixon_blog_style[1]);
$dixon_post_format = get_post_format();
$dixon_post_format = empty($dixon_post_format) ? 'standard' : str_replace('post-format-', '', $dixon_post_format);
$dixon_animation = dixon_get_theme_option('blog_animation');
$dixon_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($dixon_columns).' post_format_'.esc_attr($dixon_post_format) ); ?>
	<?php echo (!dixon_is_off($dixon_animation) ? ' data-animation="'.esc_attr(dixon_get_animation_classes($dixon_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($dixon_image[1]) && !empty($dixon_image[2])) echo intval($dixon_image[1]) .'x' . intval($dixon_image[2]); ?>"
	data-src="<?php if (!empty($dixon_image[0])) echo esc_url($dixon_image[0]); ?>"
	>

	<?php
	$dixon_image_hover = 'icon';
	if (in_array($dixon_image_hover, array('icons', 'zoom'))) $dixon_image_hover = 'dots';
	// Featured image
	dixon_show_post_featured(array(
		'hover' => $dixon_image_hover,
		'thumb_size' => dixon_get_thumb_size( strpos(dixon_get_theme_option('body_style'), 'full')!==false || $dixon_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. dixon_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'dixon') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>