<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_blog_style = explode('_', dixon_get_theme_option('blog_style'));
$dixon_columns = empty($dixon_blog_style[1]) ? 2 : max(2, $dixon_blog_style[1]);
$dixon_expanded = !dixon_sidebar_present() && dixon_is_on(dixon_get_theme_option('expand_content'));
$dixon_post_format = get_post_format();
$dixon_post_format = empty($dixon_post_format) ? 'standard' : str_replace('post-format-', '', $dixon_post_format);
$dixon_animation = dixon_get_theme_option('blog_animation');

?><div class="<?php echo trim($dixon_blog_style[0]) == 'classic' ? 'column' : 'masonry_item masonry_item'; ?>-1_<?php echo esc_attr($dixon_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($dixon_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($dixon_columns)
					. ' post_layout_'.esc_attr($dixon_blog_style[0]) 
					. ' post_layout_'.esc_attr($dixon_blog_style[0]).'_'.esc_attr($dixon_columns)
					); ?>
	<?php echo (!dixon_is_off($dixon_animation) ? ' data-animation="'.esc_attr(dixon_get_animation_classes($dixon_animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	dixon_show_post_featured( array( 'thumb_size' => dixon_get_thumb_size($dixon_blog_style[0] == 'classic'
													? (strpos(dixon_get_theme_option('body_style'), 'full')!==false 
															? ( $dixon_columns > 2 ? 'big' : 'huge' )
															: (	$dixon_columns > 2
																? ($dixon_expanded ? 'med' : 'small')
																: ($dixon_expanded ? 'big' : 'med')
																)
														)
													: (strpos(dixon_get_theme_option('body_style'), 'full')!==false 
															? ( $dixon_columns > 2 ? 'masonry-big' : 'full' )
															: (	$dixon_columns <= 2 && $dixon_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );

	if ( !in_array($dixon_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('dixon_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('dixon_action_before_post_meta'); 

			// Post meta
			dixon_show_post_meta(array(
				'categories' => true,
				'date' => true,
				'edit' => $dixon_columns < 3,
				'seo' => false,
				'share' => false,
				'counters' => 'comments',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$dixon_show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($dixon_post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($dixon_post_format, array('link', 'aside', 'status', 'quote'))) {
			dixon_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $dixon_show_learn_more ) {
			?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'dixon'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>