<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

$dixon_blog_style = explode('_', dixon_get_theme_option('blog_style'));
$dixon_columns = empty($dixon_blog_style[1]) ? 1 : max(1, $dixon_blog_style[1]);
$dixon_expanded = !dixon_sidebar_present() && dixon_is_on(dixon_get_theme_option('expand_content'));
$dixon_post_format = get_post_format();
$dixon_post_format = empty($dixon_post_format) ? 'standard' : str_replace('post-format-', '', $dixon_post_format);
$dixon_animation = dixon_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($dixon_columns).' post_format_'.esc_attr($dixon_post_format) ); ?>
	<?php echo (!dixon_is_off($dixon_animation) ? ' data-animation="'.esc_attr(dixon_get_animation_classes($dixon_animation)).'"' : ''); ?>
	>

	<?php
	// Add anchor

	// Featured image
	dixon_show_post_featured( array(
											'class' => $dixon_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => dixon_get_thumb_size(
																	strpos(dixon_get_theme_option('body_style'), 'full')!==false
																		? ( $dixon_columns > 1 ? 'huge' : 'original' )
																		: (	$dixon_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('dixon_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('dixon_action_before_post_meta'); 

			// Post meta
			$dixon_post_meta = dixon_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => $dixon_columns == 1,
									'seo' => false,
									'share' => false,
									'counters' => $dixon_columns < 3 ? 'comments' : '',
									'echo' => false
									)
								);
			dixon_show_layout($dixon_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$dixon_show_learn_more = !in_array($dixon_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($dixon_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($dixon_post_format, array('link', 'aside', 'status', 'quote'))) {
				dixon_show_layout($dixon_post_meta);
			}
			// More button
			if ( $dixon_show_learn_more ) {
				?><p><a class="more-link" href="<?php echo esc_url(get_permalink()); ?>"><?php esc_html_e('Read more', 'dixon'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>