<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage DIXON
 * @since DIXON 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$dixon_content = '';
$dixon_blog_archive_mask = '%%CONTENT%%';
$dixon_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $dixon_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($dixon_content = apply_filters('the_content', get_the_content())) != '') {
		if (($dixon_pos = strpos($dixon_content, $dixon_blog_archive_mask)) !== false) {
			$dixon_content = preg_replace('/(\<p\>\s*)?'.$dixon_blog_archive_mask.'(\s*\<\/p\>)/i', $dixon_blog_archive_subst, $dixon_content);
		} else
			$dixon_content .= $dixon_blog_archive_subst;
		$dixon_content = explode($dixon_blog_archive_mask, $dixon_content);
	}
}

// Prepare args for a new query
$dixon_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$dixon_args = dixon_query_add_posts_and_cats($dixon_args, '', dixon_get_theme_option('post_type'), dixon_get_theme_option('parent_cat'));
$dixon_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($dixon_page_number > 1) {
	$dixon_args['paged'] = $dixon_page_number;
	$dixon_args['ignore_sticky_posts'] = true;
}
$dixon_ppp = dixon_get_theme_option('posts_per_page');
if ((int) $dixon_ppp != 0)
	$dixon_args['posts_per_page'] = (int) $dixon_ppp;
// Make a new query
query_posts( $dixon_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($dixon_content) && count($dixon_content) == 2) {
	set_query_var('blog_archive_start', $dixon_content[0]);
	set_query_var('blog_archive_end', $dixon_content[1]);
}

get_template_part('index');
?>