<?php
/**
 * HTML start template part.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */
?>
<!doctype html>
<html amp <?php echo AMP_HTML_Utils::build_attributes_string( $this->get( 'html_tag_attributes' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1">
	<?php
	// Note: The following two <style> tags are combined into <style amp-custom> via AMP_Style_Sanitizer.
	// Splitting up the styles into two stylesheets allows for plugin-supplied styles via the amp_post_template_css action
	// to be excluded from the styles in the style template part, which are more important given they style the overall page.

	/**
	 * Fires when rendering <head> in Reader mode templates.
	 *
	 * @since 0.2
	 *
	 * @param AMP_Post_Template $this
	 */
	do_action( 'amp_post_template_head', $this );
	?>
	<style class="style-template-part">
		<?php $this->load_parts( [ 'style' ] ); ?>
	</style>
	<style class="amp-post-template-css-action">
		<?php
		/**
		 * Fires when printing CSS styles in Reader mode templates.
		 *
		 * Callbacks should print bare CSS without any `<style>` or `<link>` tags.
		 * As an alternative to using this, please consider:
		 *
		 *     add_action( 'amp_post_template_head', function() { wp_print_styles( 'foo' ); } );
		 *
		 * @since 0.3
		 *
		 * @param AMP_Post_Template $this
		 */
		do_action( 'amp_post_template_css', $this );
		?>
	</style>
</head>

<?php
$style_darklight_mode = digiqole_option('style_theme_setting');
$class_dark = '';
if ( $style_darklight_mode == 'dark') {
	add_filter( 'body_class', function( $classes ) {
		return array_merge( $classes, array( 'dark-mode' ) );
	} );
}
?>

<body <?php body_class(); ?>>
<?php
/**
 * Fires immediately after printing the <body>.
 *
 * @since 1.2.1
 * @see wp_body_open()
 *
 * @param AMP_Post_Template $this
 */
do_action( 'amp_post_template_body_open', $this );
