<?php
/**
 * Single Product Thumbnails
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.2
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $post, $product, $woocommerce;
$attachment_ids = $product->get_gallery_attachment_ids(); 
if ( $attachment_ids ) {
	?>
<div class="tabbable product-single-page">
	<div class="tab-content">
	<?php
		$loop = 0;
		$columns = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
		foreach ( $attachment_ids as $attachment_id ) {
			$classes = array( 'zoom' );
			if ( $loop == 0 || $loop % $columns == 0 )
				$classes[] = 'first';
			if ( ( $loop + 1 ) % $columns == 0 )
				$classes[] = 'last';
			$image_link = wp_get_attachment_url( $attachment_id );
			if ( ! $image_link )
				continue;
			$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', '670x465' ) );
			
			$image_class = esc_attr( implode( ' ', $classes ) );
			$image_title = esc_attr( get_the_title( $attachment_id ) );
			/*echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="%s" class="%s" title="%s" data-rel="prettyPhoto[product-gallery]">%s</a>', $image_link, $image_class, $image_title, $image ), $attachment_id, $post->ID, $image_class );*/?>
			
			<div id="product<?php echo $loop;?>" class="tab-pane fade <?php echo ($loop == 0) ? 'active' : '';?> in">
            	<?php echo $image ; ?>
            </div>
			<?php 
			$loop++;
		}
	?>
    </div>
    
     <ul class="nav nav-tabs">
    	<?php $loop = 0;?>
    	<?php foreach ( $attachment_ids as $attachment_id ) {
			
			if ( $loop == 0 || $loop % $columns == 0 )
				$classes[] = 'first';
			if ( ( $loop + 1 ) % $columns == 0 )
				$classes[] = 'last';
			$image_link = wp_get_attachment_url( $attachment_id );
			if ( ! $image_link )
				continue;	
			
			
			
			
		?>
        
        	<?php $image = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', '103x103' ) );?>
        <li class=""><a data-toggle="tab" href="#product<?php echo $loop;?>"><?php echo $image ; ?></a></li>
        <?php 
			$loop++;
		}?>
       
    </ul><!-- Selectors -->
    
</div>
	<?php
} else {
	
	if( has_post_thumbnail() ): ?>
        <div class="tabbable product-single-page">
        	
			<?php the_post_thumbnail( '670x465' ); ?>
            
        </div>
    
    <?php endif;
    
}
?>
