<?php
/**
 * Single Product Price, including microdata for SEO
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $post, $product;
?>
<div itemprop="offers" itemscope itemtype="http://schema.org/Offer">
	  <?php if ( $price_html = $product->get_price_html() ) : ?>
		<?php echo str_replace( array( '<del><span class="amount">', '</span></del>', '<ins><span class="amount">', '</span></ins>' ), array( '<span>', '<i>', '', '</i></span>' ), $price_html );?>
      <?php endif; ?>
	<meta itemprop="price" content="<?php echo $product->get_price(); ?>" />
	<meta itemprop="priceCurrency" content="<?php echo get_woocommerce_currency(); ?>" />
	<link itemprop="availability" href="http://schema.org/<?php echo $product->is_in_stock() ? 'InStock' : 'OutOfStock'; ?>" />
</div>