<?php
/**
 * Login form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if ( is_user_logged_in() ) 
	return;
?>
<div class="checkout-block-content" <?php if ( $hidden ) echo 'style="display:none;"'; ?>>
<form method="post">
	<?php do_action( 'woocommerce_login_form_start' ); ?>
	<?php if ( $message ) echo wpautop( wptexturize( $message ) ); ?>
		<input type="text" class="input-text" name="username" id="username" placeholder="USERNAME" />
	
	
		<input class="input-text" type="password" name="password" id="password" placeholder="PASSWORD" />
	
	<?php do_action( 'woocommerce_login_form' ); ?>
	<p>
		<?php wp_nonce_field( 'woocommerce-login' ); ?>
		<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ) ?>" />
		
			<input name="rememberme" type="checkbox" id="rememberme" value="forever" /><label> <?php _e( 'Remember me', 'wp_dictate' ); ?></label>
	</p>
    <input type="submit" name="login" value="<?php _e( 'Sigin', 'wp_dictate' ); ?>" />
	<p class="lost_password">
		<a href="<?php echo esc_url( wc_lostpassword_url() ); ?>"><?php _e( 'Lost your password?', 'wp_dictate' ); ?></a>
	</p>
	<div class="clear"></div>
	<?php do_action( 'woocommerce_login_form_end' ); ?>
</form>
</div>