<?php
/**
 * Thankyou page
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.2.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $woocommerce;?>
<div class="container">
    <?php /*?><div class="main-title sec">
        <h1><?php _e('Order Recieved', 'wp_dictate');?></h1>
        <span class="short-desc"><?php _e('We strive for excellence', 'wp_dictate');?></span>
    </div><?php */?>
    <div class="oreder-recieved">
<?php if ( $order ) : ?>
    
        <?php if ( in_array( $order->status, array( 'failed' ) ) ) : ?>
    
            <p><?php _e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction.', 'wp_dictate' ); ?></p>
    
            <p><?php
                if ( is_user_logged_in() )
                    _e( 'Please attempt your purchase again or go to your account page.', 'wp_dictate' );
                else
                    _e( 'Please attempt your purchase again.', 'wp_dictate' );
            ?></p>
    
            <p>
                <a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php _e( 'Pay', 'wp_dictate' ) ?></a>
                <?php if ( is_user_logged_in() ) : ?>
                <a href="<?php echo esc_url( get_permalink( wc_get_page_id( 'myaccount' ) ) ); ?>" class="button pay"><?php _e( 'My Account', 'wp_dictate' ); ?></a>
                <?php endif; ?>
            </p>
    
        <?php else : ?>
    
            <i class="fa fa-check-square-o"></i><p><?php _e( '<span>THANK YOU.</span> Your order has been received.', 'wp_dictate' ); ?></p>
    
            <ul class="order_details">
                <li class="order">
                    <?php _e( 'Order:', 'wp_dictate' ); ?>
                    <strong><?php echo $order->get_order_number(); ?></strong>
                </li>
                <li class="date">
                    <?php _e( 'Date:', 'wp_dictate' ); ?>
                    <strong><?php echo date_i18n( get_option( 'date_format' ), strtotime( $order->order_date ) ); ?></strong>
                </li>
                <li class="total">
                    <?php _e( 'Total:', 'wp_dictate' ); ?>
                    <strong><?php echo $order->get_formatted_order_total(); ?></strong>
                </li>
                <?php if ( $order->payment_method_title ) : ?>
                <li class="method">
                    <?php _e( 'Payment method:', 'wp_dictate' ); ?>
                    <strong><?php echo $order->payment_method_title; ?></strong>
                </li>
                <?php endif; ?>
            </ul>
            <div class="clear"></div>
    
        <?php endif; ?>
    
        <?php do_action( 'woocommerce_thankyou_' . $order->payment_method, $order->id ); ?>
        <?php do_action( 'woocommerce_thankyou', $order->id ); ?>
    	
    <?php else : ?>
    
        <i class="fa fa-check-square-o"></i><p><?php _e( '<span>THANK YOU.</span> Your order has been received.', 'wp_dictate' ); ?></p>
    
    <?php endif; ?>
    </div>
</div>
