<?php
/**
 * Checkout shipping information form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.9
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>
<div class="row-fluid">
	<div class="span12">
        <div class="checkout-block">
            <div class="checkout-block-title active-block">
                <h3><?php _e('SHIPPING ADDRESS', 'wp_dictate');?></h3>
            </div>
            <div class="checkout-block-content">
            <?php if ( WC()->cart->needs_shipping() && ! WC()->cart->ship_to_billing_address_only() ) : ?>
        
                <?php
                    if ( empty( $_POST ) ) {
        
                        $ship_to_different_address = get_option( 'woocommerce_ship_to_billing' ) == 'no' ? 1 : 0;
                        $ship_to_different_address = apply_filters( 'woocommerce_ship_to_different_address_checked', $ship_to_different_address );
        
                    } else {
        
                        $ship_to_different_address = $checkout->get_value( 'ship_to_different_address' );
        
                    }
                ?>
        
                <h3 id="ship-to-different-address">
                    <label for="ship-to-different-address-checkbox" class="checkbox"><?php _e( 'Ship to a different address?', 'wp_dictate' ); ?></label>
                    <input id="ship-to-different-address-checkbox" class="input-checkbox" <?php checked( $ship_to_different_address, 1 ); ?> type="checkbox" name="ship_to_different_address" value="1" />
                </h3>
        
                <div class="shipping_address">
        
                    <?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>
        
                    <?php foreach ( $checkout->checkout_fields['shipping'] as $key => $field ) : ?>
        
                        <?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
        
                    <?php endforeach; ?>
        
                    <?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>
        
                </div>
        
            <?php endif; ?>
 			</div>
        </div>
	</div>
</div>
        
            
           
<div class="row-fluid">
	<div class="span12">
        <div class="checkout-block">
            <div class="checkout-block-title active-block">
                <h3><?php _e('ORDER NOTE', 'wp_dictate');?></h3>
            </div>
            <div class="checkout-block-content">
            	<?php do_action( 'woocommerce_before_order_notes', $checkout ); ?>
        
				<?php if ( apply_filters( 'woocommerce_enable_order_notes_field', get_option( 'woocommerce_enable_order_comments', 'yes' ) === 'yes' ) ) : ?>
            
                    <?php if ( ! WC()->cart->needs_shipping() || WC()->cart->ship_to_billing_address_only() ) : ?>
            
                        <h3><?php _e( 'Additional Information', 'wp_dictate' ); ?></h3>
            
                    <?php endif; ?>
            
                    <?php foreach ( $checkout->checkout_fields['order'] as $key => $field ) : ?>
            
                        <?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
            
                    <?php endforeach; ?>
            
                <?php endif; ?>
				<?php do_action( 'woocommerce_after_order_notes', $checkout ); ?>
            </div>
        </div>
    </div>
</div>
