<?php
/**
 * Cart Page
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $woocommerce;
wc_print_notices();?>
<section id="inner-page">
    <div class="container">
        <?php /*?><div class="main-title sec">
            <h1><?php _e('My Cart', 'wp_dictate')?></h1>
            <span class="short-desc"><?php _e('We strive for excellence', 'wp_dictate')?></span>
        </div><!-- Page Title --><?php */?>
    
        <?php do_action( 'woocommerce_before_cart' ); ?>
    
        <form action="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" method="post">
        
       
        
        <div class="cart-table">
			<div class="cart-head">
				<h2><?php _e('IMAGE', 'wp_dictate');?></h2>
				<h2 class="long-width"><?php _e('PRODUCT NAME', 'wp_dictate');?></h2>
				<h2><?php _e('PRICE', 'wp_dictate');?></h2>
				<h2><?php _e('QUANTITY', 'wp_dictate');?></h2>
				<h2><?php _e('TOTAL', 'wp_dictate');?></h2>
			</div>
            <?php do_action( 'woocommerce_before_cart_contents' ); ?>
			<ul class="cart-list">
            	<?php
                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                    $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );?>
                    
                    <?php  if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {?>
                    
                    <li>
                        <ul class="cart-product">
                            <li>
                            	 <?php
                                    echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s"><img alt="'.__( 'Remove this item', 'wp_dictate' ).'" src="'.get_template_directory_uri().'/img/dustbin.png" class="dustbin"></a>', esc_url( WC()->cart->get_remove_url( $cart_item_key ) ), __( 'Remove this item', 'wp_dictate' ) ), $cart_item_key );
                                ?>
                                
                                 <?php
                                    $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
        
                                    if ( ! $_product->is_visible() )
                                        echo $thumbnail;
                                    else
                                        printf( '<a href="%s">%s</a>', $_product->get_permalink(), $thumbnail );
                                ?>
                            </li>
                            <li class="long-width">
                            
                            	 <?php
                                    if ( ! $_product->is_visible() )
                                        echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
                                    else
                                        echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', $_product->get_permalink(), $_product->get_title() ), $cart_item, $cart_item_key );
        
                                    // Meta data
                                    echo WC()->cart->get_item_data( $cart_item );
        
                                    // Backorder notification
                                    if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) )
                                        echo '<p class="backorder_notification">' . __( 'Available on backorder', 'wp_dictate' ) . '</p>';
                                ?>
                            
                            </li>
                            <li>
								<?php
                                        echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                                ?>
                            </li>
                            <li>
                                <div id="quantity-field">
                                	 <input type="button" onclick="setQuantity('up', this);" value="+" id="up">
                                	 <?php
										if ( $_product->is_sold_individually() ) {
											$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
										} else {
											$product_quantity = woocommerce_quantity_input( array(
												'input_name'  => "cart[{$cart_item_key}][qty]",
												'input_value' => $cart_item['quantity'],
												'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
											), $_product, false );
										}
			
										echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key );
									?>
                                   
                                   
                                    <input type="button" onclick="setQuantity('down', this);" value="-" id="down">
                                </div>
                            </li>
                            <li>
                            
                            	 <?php
                                    echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
                                ?>
                            
                            </li>
                        </ul>
                    </li>
                    
					<?php }?>
					
				<?php }?>
            	  
				
				<li>
                	  <?php if ( WC()->cart->coupons_enabled() ) { ?>
                           
        
                               <input type="text" name="coupon_code" class="input-text form-control" id="coupon_code" value="" placeholder="<?php _e( 'Coupon code', 'wp_dictate' ); ?>" /> <input type="submit" class="button" name="apply_coupon pull-left cart-btns" value="<?php _e( 'Apply Coupon', 'wp_dictate' ); ?>" />
        
                                <?php do_action('woocommerce_cart_coupon'); ?>
        
                           
                        <?php } ?>
                        
                        <input type="submit" class="checkout-button alt wc-forward pull-right cart-btns" name="proceed" value="<?php _e( 'Proceed to Checkout', 'wp_dictate' ); ?>" />
        
                        <?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
                        
                         <input type="submit" class=" pull-right cart-btns" name="update_cart" value="<?php _e( 'Update Cart', 'wp_dictate' ); ?>" /> 
        
                        <?php wp_nonce_field( 'woocommerce-cart' ); ?>
					<!--<input type="text" placeholder="Enter Promotional Code" class="form-control" />
					<input type="submit" value="APPLY CODE" class="pull-left cart-btns" />-->
					<!--<input type="submit" value="APPLY COUPON" class="pull-right cart-btns" />
					<input type="submit" value="PROCEED TO CHECKOUT" class="pull-right cart-btns" />-->
				</li>
			</ul>
		</div>
        
        <div style="clear:both;"></div>
        
         <?php do_action( 'woocommerce_before_cart_table' ); ?>
        <?php /*?><table class="shop_table cart" cellspacing="0">
            <thead>
                <tr>
                    <th class="product-remove">&nbsp;</th>
                    <th class="product-thumbnail">&nbsp;</th>
                    <th class="product-name"><?php _e( 'Product', 'wp_dictate' ); ?></th>
                    <th class="product-price"><?php _e( 'Price', 'wp_dictate' ); ?></th>
                    <th class="product-quantity"><?php _e( 'Quantity', 'wp_dictate' ); ?></th>
                    <th class="product-subtotal"><?php _e( 'Total', 'wp_dictate' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php do_action( 'woocommerce_before_cart_contents' ); ?>
        
                <?php
                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                    $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                    $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
        
                    if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                        ?>
                        <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
        
                            <td class="product-remove">
                                <?php
                                    echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s">&times;</a>', esc_url( WC()->cart->get_remove_url( $cart_item_key ) ), __( 'Remove this item', 'wp_dictate' ) ), $cart_item_key );
                                ?>
                            </td>
        
                            <td class="product-thumbnail">
                                <?php
                                    $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
        
                                    if ( ! $_product->is_visible() )
                                        echo $thumbnail;
                                    else
                                        printf( '<a href="%s">%s</a>', $_product->get_permalink(), $thumbnail );
                                ?>
                            </td>
        
                            <td class="product-name">
                                <?php
                                    if ( ! $_product->is_visible() )
                                        echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
                                    else
                                        echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', $_product->get_permalink(), $_product->get_title() ), $cart_item, $cart_item_key );
        
                                    // Meta data
                                    echo WC()->cart->get_item_data( $cart_item );
        
                                    // Backorder notification
                                    if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) )
                                        echo '<p class="backorder_notification">' . __( 'Available on backorder', 'wp_dictate' ) . '</p>';
                                ?>
                            </td>
        
                            <td class="product-price">
                                <?php
                                    echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                                ?>
                            </td>
        
                            <td class="product-quantity">
                                <?php
                                    if ( $_product->is_sold_individually() ) {
                                        $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                    } else {
                                        $product_quantity = woocommerce_quantity_input( array(
                                            'input_name'  => "cart[{$cart_item_key}][qty]",
                                            'input_value' => $cart_item['quantity'],
                                            'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                                        ), $_product, false );
                                    }
        
                                    echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key );
                                ?>
                            </td>
        
                            <td class="product-subtotal">
                                <?php
                                    echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                }
        
                do_action( 'woocommerce_cart_contents' );
                ?>
                <tr>
                    <td colspan="6" class="actions">
        
                        <?php if ( WC()->cart->coupons_enabled() ) { ?>
                            <div class="coupon">
        
                                <label for="coupon_code"><?php _e( 'Coupon', 'wp_dictate' ); ?>:</label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php _e( 'Coupon code', 'wp_dictate' ); ?>" /> <input type="submit" class="button" name="apply_coupon" value="<?php _e( 'Apply Coupon', 'wp_dictate' ); ?>" />
        
                                <?php do_action('woocommerce_cart_coupon'); ?>
        
                            </div>
                        <?php } ?>
        
                        <input type="submit" class="button" name="update_cart" value="<?php _e( 'Update Cart', 'wp_dictate' ); ?>" /> <input type="submit" class="checkout-button button alt wc-forward" name="proceed" value="<?php _e( 'Proceed to Checkout', 'wp_dictate' ); ?>" />
        
                        <?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
        
                        <?php wp_nonce_field( 'woocommerce-cart' ); ?>
                    </td>
                </tr>
        
                <?php do_action( 'woocommerce_after_cart_contents' ); ?>
            </tbody>
        </table><?php */?>
        
        <?php do_action( 'woocommerce_after_cart_table' ); ?>
        
        </form>
    
       
        <div class="row-fluid">
    
        <?php woocommerce_cart_totals(); ?>
    
        <?php woocommerce_shipping_calculator(); ?>
        </div>
      
    
    <?php do_action( 'woocommerce_after_cart' ); ?>
    </div>
</section>