<?php /* Template Name: Team */
sh_custom_header(); 
$settings  = get_post_meta(get_the_ID(), '_page_settings', true);
$paged = get_query_var('paged');
$sidebar = sh_set($settings , 'sidebar');
$span_class = ($sidebar ) ?  'span8' : 'span12' ; 
$inner_page = (sh_set( $settings , 'home_page') == "title") ? 'id="inner-page"' : '' ; ?>
<section <?php echo $inner_page; ?>>
    
    <?php if(sh_set($settings , 'header') == 'enable' && sh_set( $settings , 'home_page') == "header"): 
		$bg_img = (sh_set($settings , 'header_bg')) ? 'background-image:url('.sh_set($settings , 'header_bg').')' : '';?>
		
		<div class="full-page-head" style=" <?php echo $bg_img ; ?>">
			<div class="full-page-title">
				<h1><?php echo sh_set($settings , 'header_title') ; ?><span class="slogan"><?php echo sh_set($settings , 'sub_title') ; ?></span></h1>
				<p><?php  echo sh_set($settings , 'header_content') ; ?></p>
			</div>        
		</div><!-- Full Width Page Title -->
	
	<?php endif ; ?>
    
    <div class="container">
        <div class="row-fluid">     
            <div class="left-side-content <?php echo $span_class ; ?>">
                    <?php if( sh_set( $settings , 'home_page') == 'title' ): ?>

                        <div class="main-title sec">
                            <h1><?php the_title(); ?></h1>
                            <span class="short-desc"><?php echo sh_set($settings, 'sub_title'); ?></span> 
                        </div>

                    <?php endif; ?>
                <div class="our-team-page">
                            <div class="views-icons">
                                    <a class="list active" title="" href="#"></a>
                                    <a class="grid" title="" href="#"></a>
                            </div>
                <ul class="view-style list-view">
                 <?php $args = array('post_type'=>'dict_team', 'paged'=>$paged);
                             $meta_query = array();
                             if( sh_set( $_GET, 'keyword') == 'speciality' ) $meta_query[] = array('key' => '_dict_team_speciality','value' => sh_set($_GET, 'search_term'),'compare' => 'LIKE');
                             if( sh_set( $_GET, 'doc_loc') ) $meta_query[] = array('key' => '_dict_team_location','value' => sh_set($_GET, 'doc_loc'),'compare' => 'LIKE');
                             if( sh_set( $_GET, 'gender') ) $meta_query[] = array('key' => '_dict_team_gender','value' => sh_set($_GET, 'gender'),'compare' => '=');	
                             if( sh_set( $_GET, 'keyword') == 'name' ) $args['s'] = sh_set($_GET, 'search_term');
                             if( count( $meta_query ) > 1 ) $meta_query['relation'] = 'OR';
                             if( $meta_query ) $args['meta_query'] = $meta_query;
                             $query = new WP_Query( $args );//printr($query);
                                                    while( $query->have_posts() ): $query->the_post(); 
                                                    $team_setting = get_post_meta(get_the_ID(), '_dict_team_settings', true);?>
                                    <li>
                                            <div class="team-list row-fluid">
                                              <div class="team-list-img span4">
                                                    <?php the_post_thumbnail('770x578'); ?>	
                                                     <div class="contact-bar">
                                        <ul class="social-contact">
                                            <?php if( $fb = sh_set( $team_setting, 'facebook' ) ): ?>
                                                    <li><a title="facebook" href="<?php echo $fb; ?>"><i class="theme-icon facebook"></i></a></li>
                                            <?php endif; ?>
                                            <?php if( $tw = sh_set( $team_setting, 'twitter' ) ): ?>
                                                    <li><a title="twitter" href="<?php echo $tw; ?>"><i class="theme-icon twitter"></i></a></li>
                                            <?php endif; ?>
                                            <?php if( $gplus = sh_set( $team_setting, 'gplus' ) ): ?>
                                                    <li><a title="google plus" href="<?php echo $gplus; ?>"><i class="theme-icon gplus"></i></a></li>
                                            <?php endif; ?>
                                            <?php if( $email = sh_set( $team_setting, 'email' ) ): ?>
                                                    <li><a title="email" href="mailto:<?php echo $email; ?>"><i class="theme-icon mail"></i></a></li>
                                            <?php endif; ?>
                                        </ul>
                              </div>	
                                              </div>
                                              <div class="team-list-desc span8">
                                    <h2><i class="theme-icon user"></i>
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                    </h2>
                                    <div class="team-meta"> 
                                            <?php if(sh_set( $team_setting, 'designation' )): ?><span><?php echo sh_set( $team_setting, 'designation' ); ?></span><?php endif; ?>
                                        <?php if(sh_set( $team_setting, 'experience' )): ?>
                                            <span class="exp">
                                            <?php _e('Experience Years:', 'wp_dictate'); ?>
                                                <span><?php echo sh_set( $team_setting, 'experience' ); ?><?php _e('years', 'wp_dictate'); ?></span>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php the_excerpt(); ?>
                          </div>
                                            </div>
                                    </li>
                    <?php endwhile; ?>
                            </ul>
                </div>
                <?php _the_pagination(array('total'=>$query->max_num_pages)); ?>
                <!-- Pagination --><!-- Pagination--> 
             </div>
             <?php if($sidebar != '') { ?>
                <aside class="span4">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            <?php } ?>
        </div>
    </div>
</section>
<?php get_footer(); ?>
