<?php /* Template Name: Services */
sh_custom_header();
$settings  = get_post_meta(get_the_ID(), '_page_settings', true);
$paged = get_query_var('paged');
$inner_page = (sh_set( $settings , 'home_page') == "title" || sh_set( $settings , 'home_page') == "home") ? 'id="inner-page"' : '' ; ?>
<section <?php echo $inner_page; ?>>
	 <?php if(sh_set($settings , 'header') == 'enable' && sh_set( $settings , 'home_page') == "header"): 
		$bg_img = sh_set($settings , 'header_bg') ? 'background:url( '.sh_set($settings , 'header_bg') .')': '' ;?>
		
		<div class="full-page-head" style=" <?php echo $bg_img ; ?>">
			<div class="full-page-title">
				<h1><?php echo sh_set($settings , 'header_title') ; ?><span class="slogan"><?php echo sh_set($settings , 'sub_title') ; ?></span></h1>
				<p><?php  echo sh_set($settings , 'header_content') ; ?></p>
			</div>        
		</div><!-- Full Width Page Title -->
    
    <?php endif ; ?>
     
    <?php if( sh_set($settings , 'home_page' ) != 'title' && sh_set($settings , 'home_page' ) != 'home' ) echo '<div class="service-wos">' ;?>
    
    <div class="container">
    
       <?php if(sh_set($settings , 'sidebar')) echo '<div class="left-side-content span8">' ;?>
       
            
            <?php if( sh_set( $settings , 'home_page') == 'title' ): ?>
            <div class="main-title sec">
                <h1>
                    <?php the_title(); ?>
                </h1>
                <span class="short-desc"><?php echo sh_set($settings, 'sub_title'); ?></span> 
			</div>
            <!-- Page Title -->
            <?php endif; ?>
            
            <?php $query = new WP_Query( 'post_type=dict_service&paged='.$paged ); ?>
            
            <div class="service-page">
            <?php while( $query->have_posts() ): $query->the_post(); ?>
                
                <?php $service_settings = get_post_meta( get_the_id(), '_dict_service_settings', true );
				$char_limit = (sh_set($service_settings , 'char_limit')) ? sh_set($service_settings , 'char_limit') : 150 ; 
		
				$contents =  substr(get_the_excerpt() , 0 , $char_limit) ;
				?>
                <div class="our-service">
                    <div class="our-service-img"> 
                        
						<?php the_post_thumbnail('370x257'); ?>
                        
                        <?php if( $expertise = sh_set( $service_settings, 'services' ) ): ?>
                            <ul>
                                
								<?php foreach( $expertise as $exp ): ?>
                                	<li><i class="theme-icon check"></i><?php echo $exp; ?></li>
                                <?php endforeach; ?>
                                
                            </ul>
                        <?php endif; ?>
                    </div>
                    
                    <h2><i class="theme-icon big eye"></i><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                    <?php echo $contents;  ?>
					<a href="<?php the_permalink(); ?>" ><?php _e("Read More" , 'wp_dictate') ; ?> </a>
                    
                </div>
                
            <?php endwhile; ?>
			
			<?php _the_pagination(array('total'=>$query->max_num_pages)); ?>
                    <!-- Pagination -->
			<?php wp_reset_query();	?>
            
		</div>
        
        <?php if(sh_set($settings , 'sidebar') ):
			echo '</div>' ;?>
            
            <aside class="span4">
				<?php dynamic_sidebar(sh_set($settings , 'sidebar', 'default-sidebar')); ?>
            </aside>
            
		<?php endif; ?>
        
        <?php echo do_shortcode('[sh_recent_posts]'); ?>
        
    </div>
    
    <?php if( sh_set($settings , 'home_page' ) != 'title' && sh_set($settings , 'home_page' ) != 'home' ) echo '</div>'; ?>
</section>
<?php get_footer(); ?>
